<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Common;
use App\Models\General_Setting;
use App\Models\OnboardingScreen;
use App\Models\Smtp;
use App\Models\Social_Link;
use Illuminate\Http\Request;
use Exception;
use Illuminate\Support\Facades\Validator;

class SettingController extends Controller
{
    private $folder = "app";
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function index()
    {
        try {

            $params['result'] = Setting_Data();
            $params['result']['app_logo'] = $this->common->getImage($this->folder, $params['result']['app_logo']);
            $params['smtp'] = Smtp::select('*')->first();

            $params['social_link'] = Social_Link::get();
            foreach ($params['social_link'] as $links) {
                $this->common->imageNameToUrl([$links], 'image', $this->folder);
            }

            $params['onboardingscreen'] = OnboardingScreen::get();
            foreach ($params['onboardingscreen'] as $image) {
                $this->common->imageNameToUrl([$image], 'image', $this->folder);
            }

            if ($params['result']) {
                return view('admin.setting.index', $params);
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function App(Request $request)
    {
        try {

            $data = $request->all();
            $data["app_name"] = isset($data['app_name']) ? $data['app_name'] : '';
            $data["host_email"] = isset($data['host_email']) ? $data['host_email'] : '';
            $data["app_version"] = isset($data['app_version']) ? $data['app_version'] : '';
            $data["author"] = isset($data['author']) ? $data['author'] : '';
            $data["email"] = isset($data['email']) ? $data['email'] : '';
            $data["contact"] = isset($data['contact']) ? $data['contact'] : '';
            $data["app_desripation"] = isset($data['app_desripation']) ? $data['app_desripation'] : '';
            $data["website"] = isset($data['website']) ? $data['website'] : '';

            if (isset($data['app_logo'])) {
                $files = $data['app_logo'];
                $data['app_logo'] = $this->common->saveImage($files, $this->folder, "app_");

                $this->common->deleteImageToFolder($this->folder, basename($data['old_app_logo']));
            }

            foreach ($data as $key => $value) {
                $setting = General_Setting::where('key', $key)->first();
                if (isset($setting->id)) {
                    $setting->value = $value;
                    $setting->save();
                }
            }
            return response()->json(array('status' => 200, 'success' => __('Label.save_setting')));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function Currency(Request $request)
    {
        try {

            $data = $request->all();
            $data["currency"] = isset($data['currency']) ? $data['currency'] : '';
            $data["currency_code"] = isset($data['currency_code']) ? $data['currency_code'] : '';

            foreach ($data as $key => $value) {
                $setting = General_Setting::where('key', $key)->first();
                if (isset($setting->id)) {
                    $setting->value = $value;
                    $setting->save();
                }
            }
            return response()->json(array('status' => 200, 'success' => __('Label.save_setting')));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function DeepAr(Request $request)
    {
        try {

            $data = $request->all();
            $data['deepar_android_key'] = $data['deepar_android_key'] ?? '';
            $data['deepar_ios_key'] = $data['deepar_ios_key'] ?? '';

            foreach ($data as $key => $value) {
                $setting = General_Setting::where('key', $key)->first();
                if (isset($setting['id'])) {
                    $setting['value'] = $value;
                    $setting->save();
                }
            }
            return response()->json(['status' => 200, 'success' => __('Label.save_setting')]);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function VapIdKey(Request $request)
    {
        try {

            $data = $request->all();
            $data['vap_id_key'] = $data['vap_id_key'] ?? '';

            foreach ($data as $key => $value) {
                $setting = General_Setting::where('key', $key)->first();
                if (isset($setting['id'])) {
                    $setting['value'] = $value;
                    $setting->save();
                }
            }
            return response()->json(['status' => 200, 'success' => __('Label.save_setting')]);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    // SMTP
    public function smtpSave(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'status' => 'required',
                'host' => 'required',
                'port' => 'required',
                'protocol' => 'required',
                'user' => 'required',
                'pass' => 'required',
                'from_name' => 'required',
                'from_email' => 'required',
            ]);
            if ($validator->fails()) {
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors' => $errs));
            }

            if (isset($request->id) && $request->id != null && $request->id != "") {

                $smtp = Smtp::where('id', $request->id)->first();
                if (isset($smtp->id)) {
                    $smtp->protocol = $request->protocol;
                    $smtp->host = $request->host;
                    $smtp->port = $request->port;
                    $smtp->user = $request->user;
                    $smtp->pass = $request->pass;
                    $smtp->from_name = $request->from_name;
                    $smtp->from_email = $request->from_email;
                    $smtp->status = $request->status;
                    if ($smtp->save()) {
                        return response()->json(array('status' => 200, 'success' => __('Label.save_setting')));
                    } else {
                        return response()->json(array('status' => 400, 'errors' => __('Label.data_not_updated')));
                    }
                }
            } else {

                $insert = new Smtp();
                $insert->protocol = $request->protocol;
                $insert->host = $request->host;
                $insert->port = $request->port;
                $insert->user = $request->user;
                $insert->pass = $request->pass;
                $insert->from_name = $request->from_name;
                $insert->from_email = $request->from_email;
                $insert->status = $request->status;
                if ($insert->save()) {
                    return response()->json(array('status' => 200, 'success' => __('Label.save_setting')));
                } else {
                    return response()->json(array('status' => 400, 'errors' => __('Label.data_not_updated')));
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function Commission(Request $request)
    {
        try {

            $data = $request->all();
            $data["commission"] = isset($data['commission']) ? $data['commission'] : 0;

            foreach ($data as $key => $value) {
                $setting = General_Setting::where('key', $key)->first();
                if (isset($setting->id)) {
                    $setting->value = $value;
                    $setting->save();
                }
            }
            return response()->json(array('status' => 200, 'success' => __('Label.save_setting')));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function liveStreaming(Request $request)
    {
        try {
            $data = $request->all();
            $data["live_appid"] = isset($data['live_appid']) ? $data['live_appid'] : '';
            $data["live_appsign"] = isset($data['live_appsign']) ? $data['live_appsign'] : '';
            $data["live_serversecret"] = isset($data['live_serversecret']) ? $data['live_serversecret'] : '';

            foreach ($data as $key => $value) {
                $setting = General_Setting::where('key', $key)->first();
                if (isset($setting->id)) {
                    $setting->value = $value;
                    $setting->save();
                }
            }
            return response()->json(array('status' => 200, 'success' => __('Label.save_setting')));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function SightEngine(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'sight_engine_status' => 'required',
                'sight_engine_user_key' => 'required',
                'sight_engine_secret_key' => 'required',
                'sight_engine_concepts' => 'required',
            ]);
            if ($validator->fails()) {
                $errs = $validator->errors()->all();
                return response()->json(array('status' => 400, 'errors' => $errs));
            }

            $data = $request->all();
            
            $sight_engine_concepts = implode(',', $request->sight_engine_concepts);

            $data["sight_engine_user_key"] = isset($data['sight_engine_user_key']) ? $data['sight_engine_user_key'] : '';
            $data["sight_engine_secret_key"] = isset($data['sight_engine_secret_key']) ? $data['sight_engine_secret_key'] : '';
            $data["sight_engine_concepts"] = isset($sight_engine_concepts) ? $sight_engine_concepts : '';

            foreach ($data as $key => $value) {
                $setting = General_Setting::where('key', $key)->first();
                if (isset($setting->id)) {
                    $setting->value = $value;
                    $setting->save();
                }
            }
            return response()->json(array('status' => 200, 'success' => __('Label.save_setting')));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function onboarding_screen_status(Request $request)
    {
        try {

            $data = $request->all();
            $data["on_boarding_screen_status"] = isset($data['on_boarding_screen_status']) ? $data['on_boarding_screen_status'] : 0;

            foreach ($data as $key => $value) {
                $setting = General_Setting::where('key', $key)->first();
                if (isset($setting->id)) {
                    $setting->value = $value;
                    $setting->save();
                }
            }
            return response()->json(array('status' => 200, 'success' => __('Label.save_setting')));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    // Social Link
    public function SaveSocialLink(Request $request)
    {
        try {
            $arr_name = $request['name'];
            $arr_url = $request['url'];
            $arr_img = $request->file('image');
            $arr_old_image = $request['old_image'];

            // Save New All Link
            $not_delete_img = array();
            $not_delete_ids = array();

            for ($i = 0; $i < count($arr_name); $i++) {

                if (!empty($arr_name[$i]) && !empty($arr_url[$i])) {

                    if (!empty($arr_img[$i])) {

                        $insert = new Social_Link();
                        $insert->name = $arr_name[$i];
                        $insert->url = $arr_url[$i];
                        $insert->image = $this->common->saveImage($arr_img[$i], $this->folder, "app_");
                        $insert->save();

                        $this->common->deleteImageToFolder($this->folder, $arr_old_image[$i]);
                    } else {
                        if (!empty($arr_old_image[$i])) {

                            $insert = new Social_Link();
                            $insert->name = $arr_name[$i];
                            $insert->url = $arr_url[$i];
                            $insert->image = $arr_old_image[$i];
                            $insert->save();
                            $not_delete_img[] = $arr_old_image[$i];
                        }
                    }
                    $not_delete_ids[] = $insert->id;
                }
            }

            // Delete Old All Link 
            $all_old_link = Social_Link::whereNotIn('id', $not_delete_ids)->get();
            for ($i = 0; $i < count($all_old_link); $i++) {

                if (!in_array($all_old_link[$i]['image'], $not_delete_img)) {

                    $this->common->deleteImageToFolder($this->folder, $all_old_link[$i]['image']);
                }

                $all_old_link[$i]->delete();
            }

            return response()->json(array('status' => 200, 'success' => __('Label.save_setting')));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    // onboarding screen
    public function OnboardingScreenUpdate(Request $request)
    {
        try {

            $screen_title = $request['screen_title'];
            $screen_image = $request->file('screen_image');
            $screen_id = $request['screen_id'];
            $old_screen_image = $request['old_screen_image'];

            // remove screen from database 
            if (!empty($screen_id)) {
                $id = array_slice($screen_id, 1);
                $screen_remove = OnboardingScreen::whereNotIn('id', $id)->get();

                foreach ($screen_remove as $screen) {
                    $this->common->deleteImageToFolder($this->folder, $screen->image);
                    OnboardingScreen::where('id', $screen->id)->delete();
                }
            }

            // update screen 
            for ($i = 0; $i < count($screen_title); $i++) {
                $screentitle = $screen_title[$i];
                $screenimage = isset($screen_image[$i]) ? $screen_image[$i] : null;
                $oldscreenimage = isset($old_screen_image[$i]) ? $old_screen_image[$i] : null;
                $screenid = isset($screen_id[$i]) ? $screen_id[$i] : null;


                if (!empty($screentitle) && (!is_null($screenimage) || !is_null($oldscreenimage))) {
                    $screendata = ['title' => $screentitle];

                    // image update 
                    if (!is_null($screenimage)) {
                        $screenimagepath = $this->common->saveImage($screenimage, $this->folder, "app_");
                        $screendata['image'] = $screenimagepath;

                        $this->common->deleteImageToFolder($this->folder, basename($oldscreenimage));
                    }
                    unset($request['old_screen_image' . $i]);

                    // update if id is set 
                    if (!is_null($screenid)) {

                        OnboardingScreen::where(['id' => $screenid])->update($screendata);
                    } else {

                        OnboardingScreen::create([
                            'title' => $screentitle,
                            'image' => $screenimagepath,
                        ]);
                    }
                } else {

                    // delete if any fildes are missing 
                    OnboardingScreen::where('id', $screenid)->delete();
                    $this->common->deleteImageToFolder($this->folder, basename($oldscreenimage));
                }
            }
            return response()->json(array('status' => 200, 'success' => __('Label.save_setting')));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
}
