<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Creator_Request extends Model
{
    use HasFactory;

    protected $table = 'tbl_creator_request';
    protected $guarded = array();

    protected $casts = [
        'id' => 'integer',
        'user_id' => 'integer',
        'bank_name' => 'string',
        'account_no' => 'string',
        'ifsc_no' => 'string',
        'front_id_proof_img' => 'string',
        'back_id_proof_img' => 'string',
        'status' => 'integer',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
