<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'tbl_user';
    protected $guarded = array();

    protected $hidden = [
        'password',
    ];

    protected $casts = [
        'id' => 'integer',
        'firebase_id' => 'string',
        'user_name' => 'string',
        'full_name' => 'string',
        'email' => 'string',
        'password' => 'string',
        'country_code' => 'string',
        'mobile_number' => 'string',
        'country_name' => 'string',
        'image' => 'string',
        'type' => 'integer',
        'gender' => 'string',
        'date_of_birth' => 'string',
        'bio' => 'string',
        'device_type' => 'integer',
        'device_token' => 'string',
        'facebook_url' => 'string',
        'instagram_url' => 'string',
        'youtube_url' => 'string',
        'twitter_url' => 'string',
        'is_verified_at' => 'integer',
        'is_private' => 'integer',
        'is_creator' => 'integer',
        'bank_name' => 'string',
        'account_no' => 'string',
        'ifsc_no' => 'string',
        'front_id_proof_img' => 'string',
        'back_id_proof_img' => 'string',
        'cover_img' => 'string',
        'wallet_amount' => 'integer',
        'coin_wallet' => 'integer',
        'earned_coin' => 'integer',
        'status' => 'integer',
    ];
}
