@extends('admin.layout.page-app')
@section('page_title', __('Label.app_setting'))
@section('tab_title', __('Label.app_setting'))

@section('content')
    @include('admin.layout.sidebar')

    <!-- Select2 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" />
    
    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('Label.app_setting')}}</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('Label.Dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Label.app_setting')}}</li>
                    </ol>
                </div>
            </div>

            <?php $access = Check_Admin_Access(); ?>
            <ul class="nav nav-pills custom-tabs inline-tabs" id="pills-tab" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="app-tab" data-toggle="tab" href="#app" role="tab" aria-controls="app" aria-selected="true">{{__('Label.App Settings')}}</a>
                </li>
                @if($access == 1)
                <li class="nav-item">
                    <a class="nav-link" id="smtp-tab" data-toggle="tab" href="#smtp" role="tab" aria-controls="smtp" aria-selected="true">{{__('Label.smtp')}}</a>
                </li>
                @endif
                <li class="nav-item">
                    <a class="nav-link" id="social-tab" data-toggle="tab" href="#social" role="tab" aria-controls="social" aria-selected="false">{{__('Label.social_link')}}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="onboarding-screen-tab" data-toggle="tab" href="#onboarding-screen" role="tab" aria-controls="smtp" aria-selected="true">{{__('Label.onboarding_screen')}}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="commission-tab" data-toggle="tab" href="#commission" role="tab" aria-controls="commission" aria-selected="false">{{__('Label.commission')}}</a>
                </li>
                @if($access == 1)
                <li class="nav-item">
                    <a class="nav-link" id="live-streaming-tab" data-toggle="tab" href="#live-streaming" role="tab"aria-controls="live-streaming" aria-selected="false">{{__('Label.live_streaming')}}</a>
                </li>
                @endif
                <!-- <li class="nav-item">
                    <a class="nav-link" id="sight-engine-tab" data-toggle="tab" href="#sight-engine" role="tab"aria-controls="sight-engine" aria-selected="false">{{__('Label.sight_engine')}}</a>
                </li> -->
            </ul>

            <div class="tab-content" id="pills-tabContent">
                <!-- App Setting -->
                <div class="tab-pane fade show active" id="app" role="tabpanel" aria-labelledby="app-tab">
                    <div class="card custom-border-card">
                        <h5 class="card-header">{{__('Label.App Settings')}}</h5>
                        <div class="card-body">
                            <form id="app_setting" enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="col-md-9">
                                        <div class="form-row">
                                            <div class="form-group col-md-4">
                                                <label>{{__('Label.App Name')}}</label>
                                                <input type="text" name="app_name" value="@if($result && isset($result['app_name'])){{$result['app_name']}}@endif" class="form-control" placeholder="{{__('Label.app_name_here')}}" autofocus>
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label>{{__('Label.App Version')}}</label>
                                                <input type="text" name="app_version" value="@if($result && isset($result['app_version'])){{$result['app_version']}}@endif" class="form-control" placeholder="{{__('Label.app_version_here')}}">
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label>{{__('Label.Author')}}</label>
                                                <input type="text" name="author" value=" @if($result && isset($result['author'])){{$result['author']}}@endif" class="form-control" placeholder="{{__('Label.author_here')}}">
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="form-group col-md-4">
                                                <label>{{__('Label.Email')}} </label>
                                                <input type="email" name="email"  value="@if($result && isset($result['email'])){{$result['email']}}@endif" class="form-control" placeholder="{{__('Label.email_here')}}">
                                            </div>
                                            <div class="form-group  col-md-4">
                                                <label> {{__('Label.Contact')}} </label>
                                                <input type="text" name="contact" value="@if($result && isset($result['contact'])){{$result['contact']}}@endif" class="form-control" placeholder="{{__('Label.contact_here')}}">
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label>{{__('Label.WEBSITE')}}</label>
                                                <input type="text" name="website" value="@if($result && isset($result['website'])){{$result['website']}}@endif" class="form-control" placeholder="{{__('Label.website_here')}}">
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label>{{__('Label.APP DESCRIPATION')}}</label>
                                                <textarea name="app_desripation" rows="1" class="form-control" placeholder="{{__('Label.app_description_here')}}">@if($result && isset($result['app_desripation'])){{$result['app_desripation']}}@endif</textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group ml-5">
                                            <label class="ml-5">{{__('Label.app_logo')}}</label>
                                            <div class="avatar-upload ml-5">
                                                <div class="avatar-edit">
                                                    <input type='file' name="app_logo" id="imageUpload" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageUpload" title="Select File"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="{{$result['app_logo']}}" alt="upload_img.png" id="imagePreview">
                                                </div>
                                            </div>
                                            <input type="hidden" name="old_app_logo" value="{{$result['app_logo']}}">
                                        </div>
                                    </div>
                                </div>
                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120" onclick="app_setting()">{{__('Label.SAVE')}}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-6">
                            <div class="card custom-border-card">
                                <h5 class="card-header">{{__('Label.App Configrations')}}</h5>
                                <div class="card-body">
                                    <div class="input-group">
                                        <div class="col-2   ">
                                            <label class="pt-3" style="font-size:16px; font-weight:500; color:#1b1b1b">{{__('Label.API Path')}}</label>
                                        </div>
                                        <input type="text" readonly value="{{url('/')}}/api/" name="api_path" class="form-control" id="api_path">
                                        <div class="input-group-text ml-2" onclick="Function_Api_path()" title="Copy">
                                            <i class="fa-solid fa-copy fa-2xl"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- DeepAR -->
                            @if($access == 1)
                                <div class="card custom-border-card">
                                    <h5 class="card-header">{{__('Label.deepar')}}</h5>
                                    <div class="card-body">
                                        <form id="deepar_save" enctype="multipart/form-data" autocomplete="off">
                                            <div class="row">
                                                <div class="form-group col-12">
                                                    <label>{{__('Label.android_key')}}<span class="text-danger">*</span></label>
                                                    <input type="text" name="deepar_android_key" value="{{ $result['deepar_android_key'] }}" class="form-control" placeholder="{{__('Label.key_here')}}">
                                                </div>
                                                <div class="form-group col-12">
                                                    <label>{{__('Label.ios_key')}}<span class="text-danger">*</span></label>
                                                    <input type="text" name="deepar_ios_key" value="{{ $result['deepar_ios_key'] }}" class="form-control" placeholder="{{__('Label.key_here')}}">
                                                    <label class="mt-1 text-gray">{{__('Label.search_for_better_result')}} <a href="https://developer.deepar.ai/" target="_blank" class="btn-link">{{__('Label.click_here')}}</a></label>
                                                </div>
                                            </div>
                                            <div class="border-top pt-3 text-right">
                                                <button type="button" class="btn btn-default mw-120" onclick="deepar_save()">{{__('Label.SAVE')}}</button>
                                                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="col-6">
                            <div class="card custom-border-card">
                                <h5 class="card-header">{{__('Label.Currency Settings')}}</h5>
                                <form id="save_currency">
                                    @csrf
                                    <div class="row col-lg-12">
                                        <div class="form-group col-lg-4">
                                            <label>{{__('Label.Currency Name')}} </label>
                                            <input type="text" name="currency" class="form-control" value="{{$result['currency']}}" placeholder="{{__('Label.currency_name_here')}}">
                                        </div>
                                        <div class="form-group col-lg-4">
                                            <label> {{__('Label.Currency Code')}} </label>
                                            <input type="text" name="currency_code" class="form-control" value="{{$result['currency_code']}}" placeholder="{{__('Label.currency_code_here')}}">
                                        </div>
                                    </div>
                                    <div class="border-top pt-3 text-right">
                                        <button type="button" class="btn btn-default mw-120" onclick="save_currency()">{{__('Label.SAVE')}}</button>
                                    </div>
                                </form>
                            </div>
                            @if($access == 1)
                            <div class="card custom-border-card">
                                <h5 class="card-header">{{__('Label.vap_id_key')}}</h5>
                                <div class="card-body">
                                    <form id="save_vap_id_key">
                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <input type="text" name="vap_id_key" class="form-control" value="{{ $result['vap_id_key'] }}" placeholder="{{__('Label.key_here')}}">
                                            </div>
                                        </div>
                                        <div class="border-top pt-3 text-right">
                                            <button type="button" class="btn btn-default mw-120" onclick="save_vap_id_key()">{{__('Label.SAVE')}}</button>
                                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        </div>
                                    </form>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                <!-- Smtp -->
                <div class="tab-pane fade" id="smtp" role="tabpanel" aria-labelledby="smtp-tab">
                    <div class="card custom-border-card mt-3">
                        <h5 class="card-header">{{__('Label.Email Setting [SMTP]')}}</h5>
                        <form id="smtp_setting">
                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                            <input type="hidden" name="id" value="@if($smtp){{$smtp->id}}@endif">
                            <div class="form-row">
                                <div class="form-group  col-md-3">
                                    <label>{{__('Label.IS SMTP Active')}}</label>
                                    <select name="status" class="form-control">
                                        <option value="">{{__('Label.select_status')}}</option>
                                        <option value="0" @if($smtp){{ $smtp->status == 0  ? 'selected' : ''}}@endif>{{__('Label.No')}}</option>
                                        <option value="1" @if($smtp){{ $smtp->status == 1  ? 'selected' : ''}}@endif>{{__('Label.Yes')}}</option>
                                    </select>
                                </div>
                                <div class="form-group col-md-3">
                                    <label>{{__('Label.Host')}}</label>
                                    <input type="text" name="host" class="form-control" value="@if($smtp){{$smtp->host}}@endif" placeholder="{{__('Label.host_here')}}">
                                </div>
                                <div class="form-group col-md-3">
                                    <label>{{__('Label.Port')}}</label>
                                    <input type="text" name="port" class="form-control" value="@if($smtp){{$smtp->port}}@endif" placeholder="{{__('Label.port_here')}}">
                                </div>
                                <div class="form-group col-md-3">
                                    <label>{{__('Label.Protocol')}}</label>
                                    <input type="text" name="protocol" class="form-control" value="@if($smtp){{$smtp->protocol}}@endif" placeholder="{{__('Label.protocol_here')}}">
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-3">
                                    <label>{{__('Label.User name')}}</label>
                                    <input type="text" name="user" class="form-control" value="@if($smtp){{$smtp->user}}@endif" placeholder="{{__('Label.user_name_here')}}">
                                </div>
                                <div class="form-group col-md-3">
                                    <label>{{__('Label.Password')}}</label>
                                    <input type="password" name="pass" class="form-control" value="@if($smtp){{$smtp->pass}}@endif" placeholder="{{__('Label.password_here')}}">
                                    <label class="mt-1 text-gray">{{__('Label.search_for_better_result')}} <a href="https://support.google.com/mail/answer/185833?hl=en" target="_blank" class="btn-link">{{__('Label.click_here')}}</a></label>
                                </div>
                                <div class="form-group col-md-3">
                                    <label>{{__('Label.From name')}}</label>
                                    <input type="text" name="from_name" class="form-control" value="@if($smtp){{$smtp->from_name}}@endif" placeholder="{{__('Label.from_name_here')}}">
                                </div>
                                <div class="form-group col-md-3">
                                    <label>{{__('Label.From Email')}}</label>
                                    <input type="text" name="from_email" class="form-control" value="@if($smtp){{$smtp->from_email}}@endif" placeholder="{{__('Label.from_email_here')}}">
                                </div>
                            </div>
                            <div class="border-top pt-3 text-right">
                                <button type="button" class="btn btn-default mw-120" onclick="smtp_setting()">{{__('Label.SAVE')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
                <!-- commison -->
                <div class="tab-pane fade" id="commission" role="tabpanel" aria-labelledby="commission-tab">
                    <div class="card custom-border-card">
                        <h5 class="card-header">{{__('Label.admin_commission')}}</h5>
                        <div class="card-body">
                            <form id="save_commission">
                                @csrf
                                <div class="row col-lg-12">
                                    <div class="form-group col-lg-3">
                                        <label>{{__('Label.commission')}}</label>
                                        <input type="number" name="commission" class="form-control" value="{{ $result['commission']}}" min="0" max="100" placeholder="{{__('Label.commission_here')}}">
                                    </div>
                                    <div class="form-group col-lg-3">
                                        <label>{{__('Label.percentage')}}</label>
                                        <input type="text" readonly class="form-control" value="%">
                                    </div>
                                </div>
                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120" onclick="save_commission()">{{__('Label.SAVE')}}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- live streming -->
                <div class="tab-pane fade" id="live-streaming" role="tabpanel" aria-labelledby="live-streaming-tab">
                    <div class="card custom-border-card">
                        <h5 class="card-header">{{__('Label.live_streaming')}}</h5>
                        <div class="card-body">
                            <form id="live_streaming">
                                @csrf
                                <div class="row">
                                    <div class="form-group col-lg-4">
                                        <label>{{__('Label.app_id')}}</label>
                                        <input type="text" value="{{$result['live_appid']}}" name="live_appid" class="form-control" placeholder="{{__('Label.id_here')}}">
                                        <label class="mt-1 text-gray">{{__('Label.search_for_better_result')}} <a href="https://console.zegocloud.com/account/login" target="_blank" class="btn-link">{{__('Label.click_here')}}</a></label>
                                    </div>
                                    <div class="form-group col-lg-4">
                                        <label>{{__('Label.app_sign')}}</label>
                                        <input type="text" value="{{$result['live_appsign']}}" name="live_appsign" class="form-control" placeholder="{{__('Label.app_sign_key_here')}}">
                                    </div>
                                    <div class="form-group col-lg-4">
                                        <label>{{__('Label.server_secret')}}</label>
                                        <input type="text" value="{{$result['live_serversecret']}}" name="live_serversecret" class="form-control" placeholder="{{__('Label.server_secret_key_here')}}">
                                    </div>
                                </div>
                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120" onclick="live_streaming()">{{__('Label.SAVE')}}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- sight engine -->
                <div class="tab-pane fade" id="sight-engine" role="tabpanel" aria-labelledby="sight-engine-tab">
                    <div class="card custom-border-card">
                        <h5 class="card-header">{{ __('Label.sight_engine') }}</h5>
                        <div class="card-body">
                            <form id="sight_engine">
                                @csrf 
                                <div class="row">
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group">
                                            <label for="sight_engine_status">{{ __('Label.sight_engine_status') }}</label>
                                            <div class="radio-group">
                                                <div class="custom-control custom-radio">
                                                    <input type="radio" id="sight_engine_status" name="sight_engine_status" class="custom-control-input" {{ ($result['sight_engine_status'] == '1') ? "checked" : "" }} value="1">
                                                    <label class="custom-control-label" for="sight_engine_status">{{ __('Label.Yes') }}</label>
                                                </div>
                                                <div class="custom-control custom-radio">
                                                    <input type="radio" id="sight_engine_status1" name="sight_engine_status" class="custom-control-input" {{ ($result['sight_engine_status'] == '0') ? "checked" : "" }} value="0">
                                                    <label class="custom-control-label" for="sight_engine_status1">{{ __('Label.No') }}</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row sight_engine_content">
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group">
                                            <label>{{ __('Label.api_user_key') }}</label>
                                            <input type="text" value="{{ $result['sight_engine_user_key'] }}" name="sight_engine_user_key" class="form-control" placeholder="{{ __('Label.key_here') }}">
                                            <label class="mt-1 text-gray">{{__('Label.search_for_better_result')}} <a href="https://dashboard.sightengine.com/api-credentials" target="_blank" class="btn-link">{{ __('Label.click_here') }}</a></label>
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-4">
                                        <div class="form-group">
                                            <label>{{ __('Label.api_secret_key') }}</label>
                                            <input type="text" value="{{ $result['sight_engine_secret_key'] }}" name="sight_engine_secret_key" class="form-control" placeholder="{{ __('Label.key_here') }}">
                                        </div>
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-12">
                                        <div class="form-group">
                                            <?php $x = explode(",", $result['sight_engine_concepts']); ?>
                                            <label>{{ __('Label.concepts') }}<span class="text-danger">*</span></label>
                                            <select class="form-control" style="width:100%!important;" name="sight_engine_concepts[]" multiple id="sight_engine_concepts">
                                                <option value="nudity" {{ in_array("nudity", $x) ? 'selected' : '' }}>{{ __('Label.nudity') }}</option>
                                                <option value="nudity-raw" {{ in_array("nudity-raw", $x) ? 'selected' : '' }}>{{ __('Label.nudity_raw') }}</option>
                                                <option value="face" {{ in_array("face", $x) ? 'selected' : '' }}>{{ __('Label.face') }}</option>
                                                <option value="face-minor" {{ in_array("face-minor", $x) ? 'selected' : '' }}>{{ __('Label.face_minor') }}</option>
                                                <option value="license-plate" {{ in_array("license-plate", $x) ? 'selected' : '' }}>{{ __('Label.license_plate') }}</option>
                                                <option value="offensive" {{ in_array("offensive", $x) ? 'selected' : '' }}>{{ __('Label.offensive') }}</option>
                                                <option value="weapon" {{ in_array("weapon", $x) ? 'selected' : '' }}>{{ __('Label.weapon') }}</option>
                                                <option value="alcohol" {{ in_array("alcohol", $x) ? 'selected' : '' }}>{{ __('Label.alcohol') }}</option>
                                                <option value="recreational-drug" {{ in_array("recreational-drug", $x) ? 'selected' : '' }}>{{ __('Label.recreational_drug') }}</option>
                                                <option value="medical-drug" {{ in_array("medical-drug", $x) ? 'selected' : '' }}>{{ __('Label.medical_drug') }}</option>
                                                <option value="gore" {{ in_array("gore", $x) ? 'selected' : '' }}>{{ __('Label.gore') }}</option>
                                                <option value="text-natural" {{ in_array("text-natural", $x) ? 'selected' : '' }}>{{ __('Label.text_natural') }}</option>
                                                <option value="text-embedded" {{ in_array("text-embedded", $x) ? 'selected' : '' }}>{{ __('Label.text_embedded') }}</option>
                                                <option value="profanity" {{ in_array("profanity", $x) ? 'selected' : '' }}>{{ __('Label.profanity') }}</option>
                                                <option value="link" {{ in_array("link", $x) ? 'selected' : '' }}>{{ __('Label.link') }}</option>
                                                <option value="email" {{ in_array("email", $x) ? 'selected' : '' }}>{{ __('Label.Email') }}</option>
                                                <option value="phone" {{ in_array("phone", $x) ? 'selected' : '' }}>{{ __('Label.phone') }}</option>
                                                <option value="social" {{ in_array("social", $x) ? 'selected' : '' }}>{{ __('Label.social') }}</option>
                                                <option value="qr" {{ in_array("qr", $x) ? 'selected' : '' }}>{{ __('Label.qr') }}</option>
                                            </select>
                                            <label class="mt-1 text-gray">{{__('Label.for_better_understanding_of_concepts')}} <a href="https://sightengine.com/docs/video-redaction-and-anonymization" target="_blank" class="btn-link">{{__('Label.click_here')}}</a></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120" onclick="sight_engine()">{{__('Label.SAVE')}}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- social link -->
                <div class="tab-pane fade" id="social" role="tabpanel" aria-labelledby="social-tab">
                    <div class="card custom-border-card">
                        <h5 class="card-header">{{ __('Label.social_link') }}</h5>
                        <div class="card-body">
                            <form id="social_link" enctype="multipart/form-data">
                                @csrf
                                <div class="row col-md-12">
                                    <div class="form-group col-md-3">
                                        <label>{{ __('Label.Name') }}</label>
                                        <input type="text" name="name[]" class="form-control" placeholder="{{ __('Label.name_here') }}">
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label>{{ __('Label.URL') }}</label>
                                        <input type="url" name="url[]" class="form-control" placeholder="{{ __('Label.url_here') }}">
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label>{{ __('Label.icon') }}</label>
                                        <input type="file" name="image[]" class="form-control import-file social_img" id="social_img" accept=".png, .jpg, .jpeg">
                                        <input type="hidden" name="old_image[]" value="">
                                    </div>
                                    <div class="form-group col-md-2">
                                        <div class="custom-file">
                                            <img src="{{asset('assets/imgs/upload_img.png')}}" style="height: 90px; width: 90px;" class="img-thumbnail" id="link_img_social_img">
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-2">
                                        <div class="flex-grow-1 px-5 d-inline-flex">
                                            <div class="change mr-3 mt-4" id="add_btn">
                                                <a class="btn btn-success add-more text-white" onclick="add_more_link()">+</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @for ($i=0; $i < count($social_link); $i++)
                                    <div class="social_part">
                                        <div class="row col-lg-12">
                                            <div class="form-group col-md-3">
                                                <label>{{ __('Label.Name') }}</label>
                                                <input type="text" name="name[]" value="{{ $social_link[$i]['name'] }}" class="form-control" placeholder="{{ __('Label.name_here') }}">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{ __('Label.URL') }}</label>
                                                <input type="url" name="url[]" value="{{ $social_link[$i]['url'] }}" class="form-control" placeholder="{{ __('Label.url_here') }}">
                                            </div>
                                            <div class="form-group col-md-3">
                                                <label>{{ __('Label.icon') }}</label>
                                                <input type="file" name="image[]" class="form-control import-file social_img" id="social_img_{{$i}}" accept=".png, .jpg, .jpeg">
                                                <input type="hidden" name="old_image[]" value="{{ basename($social_link[$i]['image']) }}">
                                            </div>
                                            <div class="form-group col-md-2">
                                                <div class="custom-file">
                                                    <img src="{{$social_link[$i]['image']}}" style="height: 90px; width: 90px;" class="img-thumbnail" id="link_img_social_img_{{$i}}">
                                                </div>
                                            </div>
                                            <div class="col-md-1 mt-2">
                                                <div class="flex-grow-1 px-5 d-inline-flex">
                                                    <div class="change mr-3 mt-4" id="add_btn">
                                                        <a class="btn btn-danger text-white remove_link">-</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endfor               
                                
                                <div class="after-add-more"></div>

                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120" onclick="social_link()">{{__('Label.SAVE')}}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- Onboarding screen -->
                <div class="tab-pane fade" id="onboarding-screen" role="tabpanel" aria-labelledby="onboarding-screen-tab">
                    <div class="from-row">
                        <div class="card custom-border-card col-md-12">
                            <h5 class="card-header">{{__('Label.onboarding_screen_status')}}</h5>
                            <div class="card-body">
                                <form id="onboarding_screen_status">
                                    <div class="form-row">
                                        <div class="col-12">
                                            <div class="radio-group">
                                                <div class="custom-control custom-radio">
                                                    <input type="radio" name="on_boarding_screen_status" id="on_boarding_screen_status_yes" class="custom-control-input" value="1" {{$result['on_boarding_screen_status'] == 1 ? 'checked' : ''}}>
                                                    <label class="custom-control-label" for="on_boarding_screen_status_yes">{{__('Label.Yes')}}</label>
                                                </div>
                                                <div class="custom-control custom-radio">
                                                    <input type="radio" name="on_boarding_screen_status" id="on_boarding_screen_status_no" class="custom-control-input" value="0" {{$result['on_boarding_screen_status'] == 0 ? 'checked' : ''}}>
                                                    <label class="custom-control-label" for="on_boarding_screen_status_no">{{__('Label.No')}}</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120" onclick="save_onboardingscreen_status()">{{__('Label.SAVE')}}</button>
                                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                </div>
                            </div>
                        </div>
                    </div>
                    <form id="edit_onboarding_screen" autocomplete="off" method="post" enctype="multipart/form-data">
                        <div class="card custom-border-card mt-3">
                            <h5 class="card-header">{{__('Label.onboarding_screen')}}</h5>
                            <div class="card-body">
                                <div class="main_screen form-row mt-3 mb-3">
                                    <div class="col-md-6">
                                        <input type="hidden" name="screen_id[]" value="">
                                        <input type="hidden" name="screen_storage_type[]" value="">
                                        <div class="form-group">
                                            <label>{{__('Label.Title')}}<span class="text-danger">*</span></label>
                                            <input type="text" name="screen_title[]" class="form-control" placeholder="{{__('Label.title_here')}}">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>{{__('Label.Image')}}<span class="text-danger">*</span></label>
                                            <input type="file" class="form-control import-file screen-image" name="screen_image[]" accept="image/png, image/jpg, image/jpeg" preview-id="Uploaded-screen-Image">
                                        </div>
                                    </div>
                                    <div class="col-md-1">
                                        <div class="form-group">
                                            <div class="custom-file ml-2">
                                                <img src="{{asset('assets/imgs/upload_img.png')}}" style="height:90px; width: 120px;" class="img-thumbnail" id="Uploaded-screen-Image">
                                                <input type="hidden" name="old_screen_image[]" value="">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-2">
                                        <div class="flex-grow-1 px-5 d-inline-flex">
                                            <div class="change mr-3 mt-4" id="add_btn">
                                                <a class="add_new_screen btn btn-success add-more text-white">+</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @foreach($onboardingscreen as $index => $result)
                                <div class="main_screen form-row mt-3 mb-3">
                                    <div class="col-md-6">
                                        <input type="hidden" name="screen_id[]" value="{{ $result->id }}">
                                        <input type="hidden" name="screen_storage_type[]" value="{{ $result->storage_type }}">
                                        <div class="form-group">
                                            <label>{{__('Label.Title')}}<span class="text-danger">*</span></label>
                                            <input type="text" value="{{ $result->title }}" name="screen_title[]" class="form-control" placeholder="{{__('Label.title_here')}}">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>{{__('Label.Image')}}<span class="text-danger">*</span></label>
                                            <input type="file" class="form-control import-file screen-image" name="screen_image[]" accept="image/png, image/jpg, image/jpeg" preview-id="Uploaded-screen-Image-{{ $index }}">
                                        </div>
                                    </div>
                                    <div class="col-md-1">
                                        <div class="form-grup">
                                            <div class="custom-file ml-2">
                                                <img src="{{ $result->image }}" style="height: 90px; width: 120px;" class="img-thumbnail" id="Uploaded-screen-Image-{{ $index }}">
                                                <input type="hidden" name="old_screen_image[]" value="{{ $result->image }}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-1 mt-2">
                                        <div class="flex-grow-1 px-5 d-inline-flex">
                                            <div class="change mr-3 mt-4" id="add_btn">
                                                <a class="remove_screen btn btn-danger add-more text-white">-</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                                <div class="new_screen"></div>
                            </div>
                            <div class="border-top pt-3 text-right">
                                <button type="button" class="btn btn-default mw-120" onclick="save_onboarding_screen()">{{__('Label.SAVE')}}</button>
                                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                            </div>
                        </div>
                    </form>
                </div> 
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <!-- Select2 -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

    <script>
        // Sidebar Scroll Down
		sidebar_down($(document).height());
        
        
        $(document).ready(function() {

            $("#sight_engine_concepts").select2({
                placeholder: "Select Concepts"
            });
               
            var sight_engine_status = $('input[type=radio][name=sight_engine_status]:checked').val();
            if (sight_engine_status == 1) {

                $(".sight_engine_content").show();
            } else if (sight_engine_status == 0) {

                $(".sight_engine_content").hide();
            }
            $('input[type=radio][name=sight_engine_status]').change(function() {
                if (this.value == 1) {
                    $(".sight_engine_content").show();
                } else if (this.value == 0) {
                    $(".sight_engine_content").hide();
                }
            });
            
        });

        function Function_Api_path() {
            /* Get the text field */
            var copyText = document.getElementById("api_path");

            /* Select the text field */
            copyText.select();
            copyText.setSelectionRange(0, 99999); /* For mobile devices */

            document.execCommand('copy');

            /* Alert the copied text */
            alert("Copied the API Path: " + copyText.value);
        }
        function app_setting() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                var formData = new FormData($("#app_setting")[0]);
                $("#dvloader").show();
                $.ajax({
                    type: 'POST',
                    url: '{{ route("settingApp") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        // $("html, body").animate({ scrollTop: 0 }, "swing");
                        // get_responce_message(resp);
                        get_responce_message(resp, 'app_setting', '{{ route("setting") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
        }
        function deepar_save() {

            var formData = new FormData($("#deepar_save")[0]);
            $("#dvloader").show();
            $.ajax({
                type: 'POST',
                url: '{{ route("settingdeepar") }}',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(resp) {
                    $("#dvloader").hide();
                    $("html, body").animate({scrollTop: 0}, "swing");
                    get_responce_message(resp);
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    $("#dvloader").hide();
                    toastr.error(errorThrown, textStatus);
                }
            });
        }
        function save_vap_id_key() {

            var formData = new FormData($("#save_vap_id_key")[0]);
            $("#dvloader").show();
            $.ajax({
                type: 'POST',
                url: '{{ route("settingvapidkey") }}',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(resp) {
                    $("#dvloader").hide();
                    $("html, body").animate({scrollTop: 0}, "swing");
                    get_responce_message(resp);
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    $("#dvloader").hide();
                    toastr.error(errorThrown, textStatus);
                }
            });
        }
        function save_currency() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                var formData = new FormData($("#save_currency")[0]);
                $("#dvloader").show();
                $.ajax({
                    type: 'POST',
                    url: '{{ route("settingCurrency") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        $("html, body").animate({scrollTop: 0}, "swing");
                        get_responce_message(resp);
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
        }
        function smtp_setting() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1) {

                var formData = new FormData($("#smtp_setting")[0]);
                $.ajax({
                    type: 'POST',
                    url: '{{ route("smtpsave") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        get_responce_message(resp, 'smtp_setting', '{{ route("setting") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
        }
        function save_commission() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                var formData = new FormData($("#save_commission")[0]);
                $("#dvloader").show();
                $.ajax({
                    type: 'POST',
                    url: '{{ route("settingCommission") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        $("html, body").animate({scrollTop: 0}, "swing");
                        get_responce_message(resp);
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
        }
        function live_streaming() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){
                    
                var formData = new FormData($("#live_streaming")[0]);
                $("#dvloader").show();
                $.ajax({
                    type: 'POST',
                    url: '{{ route("settingLiveStreaming") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        $("html, body").animate({
                            scrollTop: 0
                        }, "swing");
                        get_responce_message(resp);
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
        }
        function sight_engine() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){
                    
                var formData = new FormData($("#sight_engine")[0]);
                $("#dvloader").show();
                $.ajax({
                    type: 'POST',
                    url: '{{ route("settingSightengine") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        $("html, body").animate({
                            scrollTop: 0
                        }, "swing");
                        get_responce_message(resp);
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
        }
        function save_onboardingscreen_status() {

            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                $("#dvloader").show();
                var formData = new FormData($("#onboarding_screen_status")[0]);
                $.ajax({
                    type: 'POST',
                    url: '{{ route("setting.onboardingscreen.status") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        $("html, body").animate({
                            scrollTop: 0
                        }, "swing");
                        get_responce_message(resp);
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        }
        // Multipal Img Show 
        $(document).on('change', '.social_img', function(){
            readURL(this, this.id);
        });
        function readURL(input, id) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                 
                reader.onload = function (e) {
                    $('#link_img_'+id).attr('src', e.target.result);
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        // Add Link Part
        var i = -1;
        function add_more_link(){

            var data = '<div class="social_part">';
                data += '<div class="row col-md-12">';
                data += '<div class="form-group col-md-3">';
                data += '<label>{{__("Label.Name")}}</label>';
                data += '<input type="text" name="name[]" class="form-control" placeholder="{{__("Label.name_here")}}">';
                data += '</div>';
                data += '<div class="form-group col-md-3">';
                data += '<label>{{__("Label.URL")}}</label>';
                data += '<input type="url" name="url[]" class="form-control" placeholder="{{__("Label.url_here")}}">';
                data += '</div>';
                data += '<div class="form-group col-lg-3">';
                data += '<label>{{__("Label.icon")}}</label>';
                data += '<input type="file" name="image[]" class="form-control import-file social_img" id="social_img_'+i+'" accept=".png, .jpg, .jpeg">';
                data += '<input type="hidden" name="old_image[]" value="">';
                data += '</div>';
                data += '<div class="form-group col-md-2">';
                data += '<div class="custom-file">';
                data += '<img src="{{asset("assets/imgs/upload_img.png")}}" style="height: 90px; width: 90px;" class="img-thumbnail" id="link_img_social_img_'+i+'">';
                data += '</div>';
                data += '</div>';
                data += '<div class="col-md-1 mt-2">';
                data += '<div class="flex-grow-1 px-5 d-inline-flex">';
                data += '<div class="change mr-3 mt-4" id="add_btn">';
                data += '<a class="btn btn-danger add-more text-white remove_link">-</a>';
                data += '</div>';
                data += '</div>';
                data += '</div>';
                data += '</div>';
                data += '</div>';

            $('.after-add-more').append(data);
            i--;
            $("html, body").animate({ scrollTop: $(document).height() }, "slow");
        }
        // Remove Link Part
        $("body").on("click", ".remove_link", function(e) {
            $(this).parents('.social_part').remove();
        });
        // Save Social Link
        function social_link() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                var formData = new FormData($("#social_link")[0]);
                $("#dvloader").show();
                $.ajax({
                    type: 'POST',
                    url: '{{ route("settingSocialLink") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'app_setting', '{{ route("setting") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
        }
        // onboarding screen update
        function save_onboarding_screen() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if (Check_Admin == 1) {
                $("#dvloader").show();
                var formData = new FormData($("#edit_onboarding_screen")[0]);

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    enctype: 'multipart/form-data',
                    type: 'POST',
                    url: '{{ route("onboardingscreenupdate") }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();

                        get_responce_message(resp, 'edit_onboarding_screen', '{{ route("setting") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });

            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
        }
        let screenIndex = 0;
        $(document).on('change', '.screen-image', function() {
            let reader = new FileReader();
            let previewId = $(this).attr('preview-id');

            reader.readAsDataURL(this.files[0]);
            reader.onload = function(e) {
                $('#' + previewId).attr('src', e.target.result);
            };
        });
        $(document).on('click', '.add_new_screen', function() {
            let newscreen = `
                    <div class="screen form-row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>{{__('Label.Title')}}<span class="text-danger">*</span></label>
                                <input type="text" name="screen_title[]" class="form-control" placeholder="{{__('Label.title_here')}}">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>{{__('Label.Image')}}<span class="text-danger">*</span></label>
                                <input type="file" class="form-control import-file screen-image" name="screen_image[]" accept="image/png, image/jpg, image/jpeg" preview-id="Uploaded-Image-${screenIndex}">
                            </div>
                        </div>
                        <div class="col-md-1">
                            <div class="form-group">
                                <div class="custom-file ml-2">
                                    <img src="{{asset('assets/imgs/upload_img.png')}}" style="height: 90px; width: 120px;" class="img-thumbnail" id="Uploaded-Image-${screenIndex}">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-1 mt-2">
                            <div class="flex-grow-1 px-5 d-inline-flex">
                                <div class="change mr-3 mt-4" id="add_btn">
                                    <a class="remove_screen btn btn-danger add-more text-white">-</a>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
            $('.new_screen').append(newscreen);
            screenIndex++;
        });
        // remove screen ot main screen
        $(document).on('click', '.remove_screen', function() {
            $(this).closest('.screen, .main_screen').remove();
        });
    </script>
@endsection