<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Coin_Package;
use App\Models\Coin_Package_Transaction;
use App\Models\Common;
use App\Models\Creator_Package;
use App\Models\Creator_Package_Transaction;
use App\Models\User;
use App\Models\Post;
use App\Models\Page;
use App\Models\Package;
use App\Models\Hashtag;
use App\Models\Post_Content;
use App\Models\Transaction;
use Illuminate\Support\Facades\URL;
use Exception;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    private $folder_user = "user";
    private $folder_post = "post";
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function index()
    {
        try {

            // Top Card
            $params['UserCount'] = User::where('is_creator', 0)->count();
            $params['CreatorCount'] = User::where('is_creator', 1)->count();
            $params['ImageCount'] = Post_Content::where('content_type', 1)->count();
            $params['VideoCount'] = Post_Content::where('content_type', 2)->count();
            $params['HashtagCount'] = Hashtag::count();

            // Second Card
            $params['CoinTransactionCount'] = Coin_Package_Transaction::sum('price');
            $params['CoinCurrentMounthCount'] = Coin_Package_Transaction::whereMonth('created_at', date('m'))->whereYear('created_at', date('Y'))->sum('price');
            $params['CoinPackageCount'] = Coin_Package::count();
            $params['CreatorPackageCount'] = Creator_Package::count();
            $params['CreatorTransactionCount'] = Creator_Package_Transaction::sum('price');
            $params['CreatorCurrentMounthCount'] = Creator_Package_Transaction::whereMonth('created_at', date('m'))->whereYear('created_at', date('Y'))->sum('price');

            // Most View Post
            $params['most_view_video'] = Post::orderBy('total_view', "DESC")->first();
            if (isset($params['most_view_video'])) {
                // Image Name to URL
                $post_content = Post_Content::where('post_id', $params['most_view_video']['id'])->where('content_type', 1)->first();
                if ($post_content != null) {
                    $params['most_view_video']['image'] = $this->common->getImage($this->folder_post, $post_content['content_url']);
                } else {
                    $params['most_view_video']['image'] = asset('assets/imgs/no_img.png');
                }
            }

            // User Statistice
            $user_data = [];
            $user_month = [];
            $d = date('t', mktime(0, 0, 0, date('m'), 1, date('Y')));

            for ($i = 1; $i < 13; $i++) {
                $Sum = User::whereYear('created_at', date('Y'))->whereMonth('created_at', $i)->count();
                $user_data['sum'][] = (int) $Sum;
            }
            for ($i = 1; $i <= $d; $i++) {

                $Sum = User::whereYear('created_at', date('Y'))->whereMonth('created_at', date('m'))->whereDay('created_at', $i)->count();
                $user_month['sum'][] = (int) $Sum;
            }
            $params['user_year'] = json_encode($user_data);
            $params['user_month'] = json_encode($user_month);


            // Top Creators
            $top_creator = Post::orderBy('total_view', "DESC")->get();
            $creator = array();
            for ($i = 0; $i < count($top_creator); $i++) {

                if (!in_array($top_creator[$i]['user_id'], $creator)) {

                    $creator[] = $top_creator[$i]['user_id'];
                }
            }
            $params['top_creators'] = User::whereIn('id', $creator)->get();
            // Image Name to URL
            $this->common->imageNameToUrl($params['top_creators'], 'image', $this->folder_user);

            return view('admin.dashboard.dashboard', $params);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function earningDashboard()
    {
        try {

            $params['CoinTransactionCount'] = Coin_Package_Transaction::sum('price');
            $params['CoinCurrentMounthCount'] = Coin_Package_Transaction::whereMonth('created_at', date('m'))->whereYear('created_at', date('Y'))->sum('price');
            $params['CoinPackageCount'] = Coin_Package::count();

            $params['CreatorPackageCount'] = Creator_Package::count();
            $params['CreatorTransactionCount'] = Creator_Package_Transaction::sum('price');
            $params['CreatorCurrentMounthCount'] = Creator_Package_Transaction::whereMonth('created_at', date('m'))->whereYear('created_at', date('Y'))->sum('price');

            // Most Subscribed Creator
            $params['most_subscribed_creator'] = Creator_Package_Transaction::select('to_user_id', DB::raw('SUM(price) as total_earning'))->groupBy('to_user_id')->orderBy('total_earning', 'DESC')->get();
            if ($params['most_subscribed_creator'] != null) {

                foreach ($params['most_subscribed_creator'] as $value) {

                    $creator = User::where('id', $value['to_user_id'])->first();
                    if ($creator != null) {
                        $value['full_name'] = $creator['full_name'];
                        $value['image'] = $this->common->getImage($this->folder_user, $creator['image']);
                        $value['bio'] = $creator['bio'];
                    }
                }
            }

            // Package Statistice
            $subscription = Coin_Package::get();
            $pack_data = [];
            foreach ($subscription as $row) {

                $sum = array();
                for ($i = 1; $i < 13; $i++) {

                    $Sum = Coin_Package_Transaction::where('coin_package_id', $row->id)->whereYear('created_at', date('Y'))->whereMonth('created_at', $i)->sum('price');
                    $sum[] = (int) $Sum;
                }
                $pack_data['label'][] = $row->name;
                $pack_data['sum'][] = $sum;
            }
            $params['package'] = json_encode($pack_data);

            return view('admin.dashboard.earning_dashboard', $params);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function Page()
    {
        try {
            $currentURL = URL::current();

            $link_array = explode('/', $currentURL);
            $page = end($link_array);

            $params['result'] = Page::where('page_name', $page)->first();
            $params['settings'] = Setting_Data();

            if (isset($params['result'])) {
                return view('page', $params);
            } else {
                return view('errors.404');
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
}
