<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Post;
use App\Models\Report;
use Exception;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function index(Request $request)
    {
        try {
            $params['data'] = [];
            if ($request->ajax()) {

                $data = Report::with('user', 'post')->orderBy('status', 'asc')->latest()->get();
                return DataTables()::of($data)
                    ->addIndexColumn()
                    ->addColumn('is_read', function ($row) {
                        if ($row->status == 1) {
                            return "<button type='button'  id='$row->id' onclick='change_status(\" $row->id \")'  style='background:#4e45b8; color:#fff; padding: 4px 20px; font-weight:bold; border: none; outline: none;'>" . __('Label.Yes') . "</button>";
                        } else {
                            return "<button type='button' id='$row->id' onclick='change_status(\" $row->id \")'  style='background:#4e45b8; color:#fff; padding: 4px 20px; font-weight:bold;  border: none; outline: none;'>" . __('Label.No') . "</button>";
                        }
                    })
                    ->addColumn('status', function ($row) {
                        if ($row->post && $row->post->status == 1) {
                            return "<button type='button' id='$row->id' onclick='changestatus(\" $row->post_id \", \"0\")'  style='background:#058f00; color:#fff; padding: 4px; font-weight:bold;  border: none; outline: none;'>" . __('Label.show') . "</button>";
                        } else if ($row->post) {
                            return "<button type='button'  id='$row->id' onclick='changestatus(\" $row->post_id \", \"1\")'  style='background:#e3000b; color:#fff; padding: 4px; font-weight:bold; border: none; outline: none;'>" . __('Label.hide') . "</button>";
                        }
                    })
                    ->rawColumns(['is_read', 'status'])
                    ->make(true);
            }
            return view('admin.report.index', $params);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function show(string $id)
    {
        try {
            $data = Report::where('id', $id)->first();
            if ($data->status == 0) {
                $data->status = 1;
            } elseif ($data->status == 1) {
                $data->status = 0;
            } else {
                $data->status = 0;
            }
            $data->save();
            return response()->json(array('status' => 200, 'success' => __('label.status_changed'), 'id' => $data->id, 'Status' => $data->status));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function changeStatus(Request $request)
    {
        try {

            $id = $request->id;
            $status = $request->status;
            $data = Post::where('id', $id)->first();
            if (isset($data)) {
                $data->update(['status' => $status]);
            }
            return response()->json(array('status' => 200, 'success' => __('label.status_changed')));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
}
