<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Common;
use App\Models\User;
use App\Models\Creator_Request;
use App\Models\User_Block;
use App\Models\Live_User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Exception;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

// Login Type = 1 = OTP, 2 = Goggle, 3 = Apple, 4 = Normal
class UserController extends Controller
{
    private $folder_user = "user";
    public $common;
    public $page_limit;
    public function __construct()
    {
        try {
            $this->common = new Common();
            $this->page_limit = env('PAGE_LIMIT');
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    public function registration(Request $request)
    {
        try {
            $validation = Validator::make(
                $request->all(),
                [
                    'full_name' => 'required|min:2',
                    'email' => 'required|email|unique:tbl_user',
                    'password' => 'required|min:4',
                    'country_code' => 'required',
                    'mobile_number' => [
                        'required',
                        'numeric',
                        Rule::unique('tbl_user')->where(function ($query) use ($request,) {
                            return $query->where('country_code', $request->country_code)
                                ->where('mobile_number', $request->mobile_number);
                        }),
                    ],
                    'country_name' => 'required',
                ],
                [
                    'full_name.required' => __('api_msg.full_name_is_required'),
                    'email.required' => __('api_msg.email_is_required'),
                    'password.required' => __('api_msg.password_is_required'),
                    'country_code.required' => __('api_msg.country_code_is_required'),
                    'mobile_number.required' => __('api_msg.mobile_number_is_required'),
                    'country_name.required' => __('api_msg.country_name_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }
            
            $data = User::where('email', $request->email)->first();
            if (isset($data)) {
                return $this->common->API_Response(400, __('api_msg.email_address_already_exists'));
            } else {

                $email_array = explode('@', $request->email);

                $data = array(
                    'firebase_id' => isset($request->firebase_id) ? $request->firebase_id : "",
                    'user_name' => $this->common->user_name($email_array[0]),
                    'full_name' => $request->full_name,
                    'email' => $request->email,
                    'password' => Hash::make($request->password),
                    'country_code' => $request->country_code,
                    'mobile_number' => $request->mobile_number,
                    'country_name' => $request->country_name,
                    'type' => 4,
                    'image' => "",
                    'cover_img' => "",
                    'gender' => isset($request->gender) ? $request->gender : "",
                    'date_of_birth' =>  isset($request->date_of_birth) ? $request->date_of_birth : "",
                    'bio' => $this->common->user_tag_line(),
                    'device_type' => isset($request->device_type) ? $request->device_type : 0,
                    'device_token' => isset($request->device_token) ? $request->device_token : '',
                    'facebook_url' => "",
                    'instagram_url' => "",
                    'youtube_url' => "",
                    'twitter_url' => "",
                    'is_verified_at' => 0,
                    'is_private' => 0,
                    'is_creator' => 0,
                    'wallet_amount' => 0,
                    'coin_wallet' => 0,
                    'earned_coin' => 0,
                    'bank_name' => "",
                    'account_no' => "",
                    'ifsc_no' => "",
                    'front_id_proof_img' => "",
                    'back_id_proof_img' => "",
                    'status' => 1,
                );

                $user_id = User::insertGetId($data);

                if (isset($user_id)) {

                    $user = User::where('id', $user_id)->first();

                    if (isset($user)) {

                        $this->common->imageNameToUrl(array($user), 'image', $this->folder_user);
                        $this->common->imageNameToUrl(array($user), 'cover_img', $this->folder_user);
                        $this->common->imageNameToUrl(array($user), 'front_id_proof_img', $this->folder_user);
                        $this->common->imageNameToUrl(array($user), 'back_id_proof_img', $this->folder_user);

                        // Send Mail (Type = 1- Register Mail, 2 Transaction Mail)
                        $this->common->Send_Mail(1, $user->email);

                        $title = __('Label.your_registration_is_complete');
                        $this->common->save_notification(9, 0, $user_id, 0, $title);

                        return $this->common->API_Response(200, __('api_msg.login_successfully'), array($user));
                    }
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function login(Request $request)
    {
        try {
            $this->common->package_expiry();

            if ($request->type == 1) {

                $validation = Validator::make(
                    $request->all(),
                    [
                        'country_code' => 'required',
                        'mobile_number' => 'required|numeric',
                        'country_name' => 'required',
                    ],
                    [
                        'country_code.required' => __('api_msg.country_code_is_required'),
                        'mobile_number.required' => __('api_msg.mobile_number_is_required'),
                        'country_name.required' => __('api_msg.country_name_is_required'),
                    ]
                );
            } elseif ($request->type == 2 || $request->type == 3) {

                $validation = Validator::make(
                    $request->all(),
                    [
                        'email' => 'required|email',
                    ],
                    [
                        'email.required' => __('api_msg.email_is_required'),
                    ]
                );
            } elseif ($request->type == 4) {

                $validation = Validator::make(
                    $request->all(),
                    [
                        'email' => 'required|email',
                        'password' => 'required|min:4',
                    ],
                    [
                        'email.required' => __('api_msg.email_is_required'),
                        'password.required' => __('api_msg.password_is_required'),
                    ]
                );
            } else {

                $validation = Validator::make(
                    $request->all(),
                    [
                        'type' => 'required|numeric',
                    ],
                    [
                        'type.required' => __('api_msg.type_is_required'),
                    ]
                );
            }

            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $type = isset($request->type) ? $request->type : 0;
            $firebase_id = isset($request->firebase_id) ? $request->firebase_id : '';
            $full_name = isset($request->full_name) ? $request->full_name : '';
            $email = isset($request->email) ? $request->email : '';
            $mobile_number = isset($request->mobile_number) ? $request->mobile_number : '';
            $device_type = isset($request->device_type) ? $request->device_type : 0;
            $device_token = isset($request->device_token) ? $request->device_token : '';
            $country_code = isset($request->country_code) ? $request->country_code : '';
            $country_name = isset($request->country_code) ? $request->country_name : '';

            $image = '';
            if (isset($request['image']) && $request['image'] != null) {

                $file = $request->file('image');
                $image = $this->common->saveImage($file, $this->folder_user, "user_");
            }

            // OTP
            if ($type == 1) {

                $user = User::where('mobile_number', $mobile_number)->where('country_code', $country_code)->first();

                if (isset($user) && $user != null) {

                    // Update Device Token && Type && Firebase Id
                    User::where('id', $user['id'])->update(['device_token' => $device_token]);
                    User::where('id', $user['id'])->update(['device_type' => $device_type]);
                    User::where('id', $user['id'])->update(['firebase_id' => $firebase_id]);
                    $user['device_type'] = $device_type;
                    $user['device_token'] = $device_token;
                    $user['firebase_id'] = $firebase_id;

                    $title = __('Label.welcome_back_you_are_successfully_logged_in');
                    $this->common->save_notification(9, 0, $user->id, 0, $title);

                    $this->common->imageNameToUrl(array($user), 'image', $this->folder_user);
                    $this->common->imageNameToUrl(array($user), 'cover_img', $this->folder_user);
                    $this->common->imageNameToUrl(array($user), 'front_id_proof_img', $this->folder_user);
                    $this->common->imageNameToUrl(array($user), 'back_id_proof_img', $this->folder_user);

                    return $this->common->API_Response(200, __('api_msg.login_successfully'), array($user));
                } else {

                    $data = array(
                        'firebase_id' => $firebase_id,
                        'user_name' => $this->common->user_name($mobile_number),
                        'full_name' => $full_name,
                        'email' => "",
                        'password' => "",
                        'country_code' => $country_code,
                        'mobile_number' => $mobile_number,
                        'country_name' => $country_name,
                        'image' => "",
                        'type' => $type,
                        'gender' => "",
                        'date_of_birth' => "",
                        'bio' => $this->common->user_tag_line(),
                        'device_type' => $device_type,
                        'device_token' => $device_token,
                        'facebook_url' => "",
                        'instagram_url' => "",
                        'youtube_url' => "",
                        'twitter_url' => "",
                        'is_verified_at' => 0,
                        'is_private' => 0,
                        'is_creator' => 0,
                        'bank_name' => "",
                        'account_no' => "",
                        'ifsc_no' => "",
                        'front_id_proof_img' => "",
                        'back_id_proof_img' => "",
                        'cover_img' => "",
                        'wallet_amount' => 0,
                        'coin_wallet' => 0,
                        'earned_coin' => 0,
                        'status' => 1,
                    );

                    $user_id = User::insertGetId($data);

                    if (isset($user_id)) {

                        $user = User::where('id', $user_id)->first();

                        $title = __('Label.welcome_back_you_are_successfully_logged_in');
                        $this->common->save_notification(9, 0, $user->id, 0, $title);

                        $this->common->imageNameToUrl(array($user), 'image', $this->folder_user);
                        $this->common->imageNameToUrl(array($user), 'cover_img', $this->folder_user);
                        $this->common->imageNameToUrl(array($user), 'front_id_proof_img', $this->folder_user);
                        $this->common->imageNameToUrl(array($user), 'back_id_proof_img', $this->folder_user);

                        return $this->common->API_Response(200, __('api_msg.login_successfully'), array($user));
                    } else {
                        return $this->common->API_Response(400, __('api_msg.data_not_save'));
                    }
                }
            }

            // Google || Apple
            if ($type == 2 || $type == 3) {

                $user = User::where('email', $email)->first();

                if (isset($user) && $user != null) {

                    // Update Device Token && Type
                    User::where('id', $user['id'])->update(['device_token' => $device_token]);
                    User::where('id', $user['id'])->update(['device_type' => $device_type]);
                    User::where('id', $user['id'])->update(['firebase_id' => $firebase_id]);
                    $user['device_type'] = $device_type;
                    $user['device_token'] = $device_token;
                    $user['firebase_id'] = $firebase_id;

                    $title = __('Label.welcome_back_you_are_successfully_logged_in');
                    $this->common->save_notification(9, 0, $user->id, 0, $title);

                    $this->common->imageNameToUrl(array($user), 'image', $this->folder_user);
                    $this->common->imageNameToUrl(array($user), 'cover_img', $this->folder_user);
                    $this->common->imageNameToUrl(array($user), 'front_id_proof_img', $this->folder_user);
                    $this->common->imageNameToUrl(array($user), 'back_id_proof_img', $this->folder_user);

                    return $this->common->API_Response(200, __('api_msg.login_successfully'), array($user));
                } else {

                    $email_array = explode('@', $request->email);

                    $data = array(
                        'firebase_id' => $firebase_id,
                        'user_name' => $this->common->user_name($email_array[0]),
                        'full_name' => $full_name,
                        'email' => $email,
                        'password' => "",
                        'country_code' => "",
                        'mobile_number' => "",
                        'country_name' => "",
                        'image' => $image,
                        'type' => $type,
                        'gender' => "",
                        'date_of_birth' => "",
                        'bio' => $this->common->user_tag_line(),
                        'device_type' => $device_type,
                        'device_token' => $device_token,
                        'facebook_url' => "",
                        'instagram_url' => "",
                        'youtube_url' => "",
                        'twitter_url' => "",
                        'is_verified_at' => 0,
                        'is_private' => 0,
                        'is_creator' => 0,
                        'bank_name' => "",
                        'account_no' => "",
                        'ifsc_no' => "",
                        'front_id_proof_img' => "",
                        'back_id_proof_img' => "",
                        'cover_img' => "",
                        'wallet_amount' => 0,
                        'coin_wallet' => 0,
                        'earned_coin' => 0,
                        'status' => 1,
                    );

                    $user_id = User::insertGetId($data);

                    if (isset($user_id)) {

                        $user = User::where('id', $user_id)->first();

                        $this->common->imageNameToUrl(array($user), 'image', $this->folder_user);
                        $this->common->imageNameToUrl(array($user), 'cover_img', $this->folder_user);
                        $this->common->imageNameToUrl(array($user), 'front_id_proof_img', $this->folder_user);
                        $this->common->imageNameToUrl(array($user), 'back_id_proof_img', $this->folder_user);

                        // Send Mail (Type = 1- Register Mail, 2 Transaction Mail)
                        if ($type == 2 || $type == 3) {
                            $this->common->Send_Mail(3, $user->email);
                        }
                        $title = __('Label.welcome_back_you_are_successfully_logged_in');
                        $this->common->save_notification(9, 0, $user->id, 0, $title);

                        return $this->common->API_Response(200, __('api_msg.login_successfully'), array($user));
                    } else {
                        return $this->common->API_Response(400, __('api_msg.data_not_save'));
                    }
                }
            }

            // Normal
            if ($type == 4) {

                $user = User::where('email', $email)->first();

                if (isset($user)) {

                    if (Hash::check($request->password, $user->password)) {

                        // Update Device Token && Type
                        User::where('id', $user['id'])->update(['device_token' => $device_token]);
                        User::where('id', $user['id'])->update(['device_type' => $device_type]);
                        User::where('id', $user['id'])->update(['firebase_id' => $firebase_id]);
                        $user['device_type'] = $device_type;
                        $user['device_token'] = $device_token;
                        $user['firebase_id'] = $firebase_id;

                        $title = __('Label.welcome_back_you_are_successfully_logged_in');
                        $this->common->save_notification(9, 0, $user->id, 0, $title);

                        // Image Name to URL
                        $this->common->imageNameToUrl(array($user), 'image', $this->folder_user);
                        $this->common->imageNameToUrl(array($user), 'cover_img', $this->folder_user);
                        $this->common->imageNameToUrl(array($user), 'front_id_proof_img', $this->folder_user);
                        $this->common->imageNameToUrl(array($user), 'back_id_proof_img', $this->folder_user);

                        return $this->common->API_Response(200, __('api_msg.login_successfully'), array($user));
                    } else {
                        return $this->common->API_Response(400, __('api_msg.email_pass_worng'));
                    }
                } else {
                    return $this->common->API_Response(400, __('api_msg.email_pass_worng'));
                }
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function get_profile(Request $request)
    {
        try {

            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required|numeric',
                    'to_user_id' => 'required|numeric',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                    'to_user_id.required' => __('api_msg.to_user_id_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $user_id = $request['user_id'];
            $to_user_id = $request['to_user_id'];

            if ($user_id != $to_user_id) {
                $where = [
                    ['id', $to_user_id],
                ];
            } else {
                $where = [
                    ['id', $user_id],
                ];
            }

            $user_data = User::where($where)->first();
            if (!empty($user_data) && isset($user_data) && $user_data != null) {

                // is_block
                $user_block = User_Block::where('user_id', $user_id)->where('block_user_id', $to_user_id)->first();
                $user_data['is_block'] = 0;
                if (isset($user_block['id'])) {
                    $user_data['is_block'] = 1;
                }

                // // Follow-Following
                // $user_data['is_follow'] = $this->common->is_follow($user_id, $to_user_id);
                // $user_data['follow'] = $this->common->follow($user_id, $to_user_id);
                // $user_data['following'] = $this->common->following($user_id, $to_user_id);

                // Image Name to URL
                $this->common->imageNameToUrl(array($user_data), 'image', $this->folder_user);
                $this->common->imageNameToUrl(array($user_data), 'cover_img', $this->folder_user);
                $this->common->imageNameToUrl(array($user_data), 'front_id_proof_img', $this->folder_user);
                $this->common->imageNameToUrl(array($user_data), 'back_id_proof_img', $this->folder_user);

                // is_buy
                $user_data['is_buy'] = $this->common->is_any_package_buy($user_id, $to_user_id);

                return $this->common->API_Response(200, __('api_msg.get_record_successfully'), array($user_data));
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function update_profile(Request $request)
    {
        try {

            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required|numeric',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $user_id = $request->user_id;
            $data = User::where('id', $user_id)->first();

            $array = array();
            if (!empty($data) && isset($data) && $data != null) {

                if (isset($request->firebase_id) && $request->firebase_id != '') {
                    $array['firebase_id'] = $request->firebase_id;
                }
                if (isset($request->user_name) && $request->user_name != '') {

                    $check = User::where('user_name', $request->user_name)->first();
                    if (isset($check) && $check != null) {
                        if ($check->id == $data->id) {
                            $array['user_name'] = $request->user_name;
                        } else {
                            return $this->common->API_Response(400, __('api_msg.user_name_exists'));
                        }
                    } else {

                        $array['user_name'] = $request->user_name;
                    }
                }
                if (isset($request->full_name) && $request->full_name != '') {
                    $array['full_name'] = $request->full_name;
                }
                if (isset($request->email) && $request->email != '') {

                    $email = $request->email;
                    $email_data = User::where('id', '!=', $user_id)->where('email', $email)->first();
                    if ($email_data != null) {
                        return $this->common->API_Response(400, __('api_msg.email_already_exits'));
                    } else {
                        $array['email'] = $email;
                    }
                }
                if (isset($request->password) && $request->password != '') {
                    $array['password'] = hash::make($request->password);
                }
                if ((isset($request->mobile_number) && $request->mobile_number != '') && (isset($request->country_code) && $request->country_code != '')) {

                    $mobile_number = User::where('id', '!=', $user_id)->where('country_code', $request->country_code)->where('mobile_number', $request->mobile_number)->first();
                    if ($mobile_number != null) {
                        return $this->common->API_Response(400, __('api_msg.mobile_number_already_exits'));
                    } else {
                        $array['mobile_number'] = $request->mobile_number;
                        $array['country_code'] = $request->country_code;
                    }
                }
                if (isset($request->country_name) && $request->country_name != '') {
                    $array['country_name'] = $request->country_name;
                }
                if (isset($request->gender) && $request->gender != '') {
                    $array['gender'] = $request->gender;
                }
                if (isset($request->date_of_birth) && $request->date_of_birth != '') {
                    $array['date_of_birth'] = $request->date_of_birth;
                }
                if (isset($request->image) && $request->file('image') != '') {

                    $image = $request->file('image');
                    $old_image = $data['image'];

                    $array['image'] = $this->common->saveImage($image, $this->folder_user, "user_");
                    $this->common->deleteImageToFolder($this->folder_user, $old_image);
                }
                if (isset($request->cover_img) && $request->file('cover_img') != '') {

                    $cover_img = $request->file('cover_img');
                    $old_cover_img = $data['cover_img'];

                    $array['cover_img'] = $this->common->saveImage($cover_img, $this->folder_user, "user_");
                    $this->common->deleteImageToFolder($this->folder_user, $old_cover_img);
                }
                if (isset($request->bio) && $request->bio != '') {
                    $array['bio'] = $request->bio;
                }
                if (isset($request->device_type) && $request->device_type != '') {
                    $array['device_type'] = $request->device_type;
                }
                if (isset($request->device_token) && $request->device_token != '') {
                    $array['device_token'] = $request->device_token;
                }
                if (isset($request->facebook_url) && $request->facebook_url != '') {
                    $array['facebook_url'] = $request->facebook_url;
                }
                if (isset($request->instagram_url) && $request->instagram_url != '') {
                    $array['instagram_url'] = $request->instagram_url;
                }
                if (isset($request->youtube_url) && $request->youtube_url != '') {
                    $array['youtube_url'] = $request->youtube_url;
                }
                if (isset($request->twitter_url) && $request->twitter_url != '') {
                    $array['twitter_url'] = $request->twitter_url;
                }
                if (isset($request->is_private) && $request->is_private != '') {
                    $array['is_private'] = $request->is_private;
                }
                if (isset($request->bank_name) && $request->bank_name != '') {
                    $array['bank_name'] = $request->bank_name;
                }
                if (isset($request->account_no) && $request->account_no != '') {
                    $array['account_no'] = $request->account_no;
                }
                if (isset($request->ifsc_no) && $request->ifsc_no != '') {
                    $array['ifsc_no'] = $request->ifsc_no;
                }

                User::where('id', $request->user_id)->update($array);

                $user = User::where('id', $request->user_id)->first();
                // send maill
                $this->common->Send_Mail(7, $user->email);
                // send notification
                $title = __('Label.profile_updated_successfully');
                $this->common->save_notification(9, 0, $user->id, 0, $title);

                $this->common->imageNameToUrl(array($user), 'image', $this->folder_user);
                $this->common->imageNameToUrl(array($user), 'cover_img', $this->folder_user);
                $this->common->imageNameToUrl(array($user), 'id_proof_img', $this->folder_user);

                return $this->common->API_Response(200, __('api_msg.profile_update_successfully'), array($user));
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function account_verify(Request $request)
    {
        try {
            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required|numeric',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $check = User::where('id', $request->user_id)->first();

            if (isset($check) && $check != null) {

                User::where('id', $request->user_id)->update(['is_verified_at' => 1]);
                return $this->common->API_Response(200, __('api_msg.account_verify_successfully'));
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    // Become Creator
    public function become_creator(Request $request)
    {
        try {
            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required|numeric',
                    'bank_name' => 'required',
                    'account_no' => 'required',
                    'ifsc_no' => 'required',
                    'front_id_proof_img' => 'required|image|mimes:jpeg,png,jpg|max:2048',
                    'back_id_proof_img' => 'required|image|mimes:jpeg,png,jpg|max:2048',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                    'bank_name.required' => __('api_msg.bank_name_is_required'),
                    'account_no.required' => __('api_msg.account_no_is_required'),
                    'ifsc_no.required' => __('api_msg.ifsc_no_is_required'),
                    'front_id_proof_img.required' => __('api_msg.front_id_proof_img_is_required'),
                    'back_id_proof_img.required' => __('api_msg.back_id_proof_img_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $is_creator = User::where('id', $request->user_id)->first();
            if (isset($is_creator) && $is_creator != null && $is_creator['is_creator'] == 1) {
                return $this->common->API_Response(400, __('api_msg.you_are_already_a_creator'));
            }

            $creator_request = Creator_Request::where('user_id', $request->user_id)->first();
            if (isset($creator_request) && $creator_request != null) {
                return $this->common->API_Response(400, __('api_msg.you_have_already_sent_the_request'));
            }

            $insert = new Creator_Request();
            $insert->user_id = $request->user_id;
            $insert->bank_name = $request->bank_name;
            $insert->account_no = $request->account_no;
            $insert->ifsc_no = $request->ifsc_no;

            $insert->front_id_proof_img = "";
            if (isset($request->front_id_proof_img)) {
                $files = $request->front_id_proof_img;
                $insert->front_id_proof_img = $this->common->saveImage($files, $this->folder_user, "front_id_proof_");
            }
            $insert->back_id_proof_img = "";
            if (isset($request->back_id_proof_img)) {
                $files = $request->back_id_proof_img;
                $insert->back_id_proof_img = $this->common->saveImage($files, $this->folder_user, "back_id_proof_");
            }

            if ($insert->save()) {

                $this->common->Send_Mail(4, $is_creator->email);

                $title =  __('Label.request_submitted_we_are_reviewing_your_application');
                $this->common->save_notification(9, 0, $request->user_id, 0, $title);

                return $this->common->API_Response(200, __('api_msg.your_request_has_been_sent_successfully_wait_for_admin_to_approve'), []);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_save'));
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    // Serach
    public function search_user(Request $request)
    {
        try {
            $validation = Validator::make(
                $request->all(),
                [
                    'name' => 'required',
                ],
                [
                    'name.required' => __('api_msg.name_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $name = $request->name;
            $user_id = isset($request->user_id) ? $request->user_id : 0;

            $block_user_list = $this->common->get_block_user($user_id);

            $page_size = 0;
            $current_page = 0;
            $more_page = false;

            $data = User::where('id', '!=', $user_id)->where('is_creator', 1)->whereNotIn('id', $block_user_list)->orderBy('id', "DESC");
            $data = $data->where(function ($query) use ($name) {
                $query->where('full_name', 'like', "%$name%")->orWhere('user_name', 'like', "%$name%");
            });

            $total_rows = $data->count();
            $total_page = $this->page_limit;
            $page_size = ceil($total_rows / $total_page);
            $current_page = $request->page_no ?? 1;
            $offset = $current_page * $total_page - $total_page;

            $more_page = $this->common->more_page($current_page, $page_size);
            $pagination = $this->common->pagination_array($total_rows, $page_size, $current_page, $more_page);

            $data->take($total_page)->offset($offset);
            $data = $data->get();

            if (count($data) > 0) {

                $this->common->imageNameToUrl($data, 'image', $this->folder_user);
                $this->common->imageNameToUrl($data, 'cover_img', $this->folder_user);
                $this->common->imageNameToUrl($data, 'id_proof_img', $this->folder_user);

                return $this->common->API_Response(200, __('api_msg.get_record_successfully'), $data, $pagination);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    // public function search_history(Request $request)
    // {
    //     try {
    //         $validation = Validator::make(
    //             $request->all(),
    //             [
    //                 'user_id' => 'required|numeric',
    //             ],
    //             [
    //                 'user_id.required' => __('api_msg.user_id_is_required'),
    //             ]
    //         );
    //         if ($validation->fails()) {
    //             $data['status'] = 400;
    //             $data['message'] = $validation->errors()->first();
    //             return $data;
    //         }

    //         $user_id = $request->user_id;

    //         $page_size = 0;
    //         $current_page = 0;
    //         $more_page = false;

    //         $data = Search::where('user_id', $user_id)->with('to_user')->orderBy('id', "DESC");

    //         $total_rows = $data->count();
    //         $total_page = $this->page_limit;
    //         $page_size = ceil($total_rows / $total_page);
    //         $current_page = $request->page_no ?? 1;
    //         $offset = $current_page * $total_page - $total_page;

    //         $more_page = $this->common->more_page($current_page, $page_size);
    //         $pagination = $this->common->pagination_array($total_rows, $page_size, $current_page, $more_page);

    //         $data->take($total_page)->offset($offset);
    //         $data = $data->get();

    //         if (count($data) > 0) {

    //             for ($i = 0; $i < count($data); $i++) {

    //                 $data[$i]['user_name'] = "";
    //                 $data[$i]['full_name'] = "";
    //                 $data[$i]['image'] = "";
    //                 $data[$i]['is_follow'] = 0;
    //                 $data[$i]['is_private'] = 0;
    //                 $data[$i]['is_creator'] = 0;
    //                 $data[$i]['is_buy'] = 0;
    //                 if ($data[$i]['to_user'] != null) {
    //                     $data[$i]['user_name'] = $data[$i]['to_user']['user_name'];
    //                     $data[$i]['full_name'] = $data[$i]['to_user']['full_name'];
    //                     $data[$i]['image'] = $this->common->getImage($this->folder_user, $data[$i]['to_user']['image']);
    //                     $data[$i]['is_follow'] = $this->common->is_follow($user_id, $data[$i]['to_user']['id']);
    //                     $data[$i]['is_private'] = $data[$i]['to_user']['is_private'];
    //                     $data[$i]['is_creator'] = $data[$i]['to_user']['is_creator'];
    //                     $data[$i]['is_buy'] = $this->common->is_any_package_buy($user_id);
    //                 }

    //                 unset($data[$i]['to_user']);
    //             }
    //             return $this->common->API_Response(200, __('api_msg.get_record_successfully'), $data, $pagination);
    //         } else {
    //             return $this->common->API_Response(400, __('api_msg.data_not_found'));
    //         }
    //     } catch (Exception $e) {
    //         return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
    //     }
    // }
    // public function add_search_user(Request $request)
    // {
    //     try {

    //         $validation = Validator::make(
    //             $request->all(),
    //             [
    //                 'user_id' => 'required|numeric',
    //                 'to_user_id' => 'required|numeric',
    //             ],
    //             [
    //                 'user_id.required' => __('api_msg.user_id_is_required'),
    //                 'to_user_id.required' => __('api_msg.to_user_id_is_required'),
    //             ]
    //         );
    //         if ($validation->fails()) {
    //             $data['status'] = 400;
    //             $data['message'] = $validation->errors()->first();
    //             return $data;
    //         }

    //         $user_id = $request['user_id'];
    //         $to_user_id = $request['to_user_id'];

    //         $search = Search::where('user_id', $user_id)->where('to_user_id', $to_user_id)->where('status', 1)->first();

    //         if (!isset($search['id'])) {

    //             $data['user_id'] = $user_id;
    //             $data['to_user_id'] = $to_user_id;

    //             $added_id = Search::insertGetId($data);
    //             $add_suggenstion = Suggestion_User::insertGetId($data);
    //         }

    //         return $this->common->API_Response(200, __('api_msg.user_search_successfully'));
    //     } catch (Exception $e) {
    //         return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
    //     }
    // }
    // public function remove_search_user(Request $request)
    // {
    //     try {

    //         $validation = Validator::make(
    //             $request->all(),
    //             [
    //                 'user_id' => 'required|numeric',
    //                 'to_user_id' => 'required|numeric',
    //             ],
    //             [
    //                 'user_id.required' => __('api_msg.user_id_is_required'),
    //                 'to_user_id.required' => __('api_msg.to_user_id_is_required'),
    //             ]
    //         );
    //         if ($validation->fails()) {
    //             $data['status'] = 400;
    //             $data['message'] = $validation->errors()->first();
    //             return $data;
    //         }

    //         $user_id = $request['user_id'];
    //         $to_user_id = $request['to_user_id'];

    //         Search::where('user_id', $user_id)->where('to_user_id', $to_user_id)->where('status', 1)->delete();

    //         return $this->common->API_Response(200, __('api_msg.record_delete_successfully'));
    //     } catch (Exception $e) {
    //         return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
    //     }
    // }
    // public function clear_search_history(Request $request)
    // {
    //     try {
    //         $validation = Validator::make(
    //             $request->all(),
    //             [
    //                 'user_id' => 'required|numeric',
    //             ],
    //             [
    //                 'user_id.required' => __('api_msg.user_id_is_required'),
    //             ]
    //         );
    //         if ($validation->fails()) {
    //             $data['status'] = 400;
    //             $data['message'] = $validation->errors()->first();
    //             return $data;
    //         }

    //         $user_id = $request->user_id;

    //         Search::where('user_id', $user_id)->delete();

    //         return $this->common->API_Response(200, __('api_msg.search_history_clear'));
    //     } catch (Exception $e) {
    //         return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
    //     }
    // }

    // Block
    public function add_remove_user_block(Request $request)
    {
        try {

            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required|numeric',
                    'block_user_id' => 'required|numeric',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                    'block_user_id.required' => __('api_msg.block_user_id_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $user_id = $request['user_id'];
            $block_user_id = $request['block_user_id'];

            $search = User_Block::where('user_id', $user_id)->where('block_user_id', $block_user_id)->where('status', 1)->first();

            if (!isset($search['id'])) {

                $data['user_id'] = $user_id;
                $data['block_user_id'] = $block_user_id;

                User_Block::insertGetId($data);

                return $this->common->API_Response(200, __('api_msg.user_block_successfully'));
            } else {

                User_Block::where('user_id', $user_id)->where('block_user_id', $block_user_id)->where('status', 1)->delete();

                $data['user_id'] = $user_id;
                $data['to_user_id'] = $block_user_id;
               
                return $this->common->API_Response(200, __('api_msg.user_unblock_successfully'));
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function user_block_list(Request $request)
    {
        try {

            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required|numeric',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $user_id = $request['user_id'];

            $page_size = 0;
            $current_page = 0;
            $more_page = false;

            $data = User_Block::where('user_id', $user_id)->with('block_user')->orderBy('id', 'DESC');

            $total_rows = $data->count();
            $total_page = $this->page_limit;
            $page_size = ceil($total_rows / $total_page);
            $current_page = $request->page_no ?? 1;
            $offset = $current_page * $total_page - $total_page;

            $more_page = $this->common->more_page($current_page, $page_size);
            $pagination = $this->common->pagination_array($total_rows, $page_size, $current_page, $more_page);

            $data->take($total_page)->offset($offset);
            $data = $data->get();

            if (count($data) > 0) {

                foreach ($data as $key => $value) {

                    $value['user_name'] = "";
                    $value['full_name'] = "";
                    $value['image'] = "";
                    if ($value['block_user'] != null) {

                        $value['user_name'] = $value['block_user']['user_name'];
                        $value['full_name'] = $value['block_user']['full_name'];
                        $value['image'] = $this->common->getImage($this->folder_user, $value['block_user']['image']);
                    }

                    unset($value['block_user']);
                }

                return $this->common->API_Response(200, __('api_msg.get_record_successfully'), $data, $pagination);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    // // Suggestion List
    // public function suggestion_user_list(Request $request)
    // {
    //     try {

    //         $user_id = isset($request->user_id) ? $request->user_id : 0;

    //         $page_size = 0;
    //         $current_page = 0;
    //         $more_page = false;

    //         $data = Suggestion_User::where('to_user_id', $user_id)->with('user')->orderBy('id', "DESC");

    //         $total_rows = $data->count();
    //         $total_page = $this->page_limit;
    //         $page_size = ceil($total_rows / $total_page);
    //         $current_page = $request->page_no ?? 1;
    //         $offset = $current_page * $total_page - $total_page;

    //         $more_page = $this->common->more_page($current_page, $page_size);
    //         $pagination = $this->common->pagination_array($total_rows, $page_size, $current_page, $more_page);

    //         $data->take($total_page)->offset($offset);
    //         $data = $data->get();

    //         if (count($data) > 0) {

    //             foreach ($data as $key => $value) {

    //                 $value['user_name'] = "";
    //                 $value['full_name'] = "";
    //                 $value['image'] = "";
    //                 $value['price_list_id'] = 0;
    //                 $value['price'] = "";
    //                 $value['android_product_package'] = "";
    //                 $value['ios_product_package'] = "";
    //                 $value['web_product_package'] = "";
    //                 if ($value['user'] != null) {

    //                     $value['user_name'] = $value['user']['user_name'];
    //                     $value['full_name'] = $value['user']['full_name'];
    //                     $value['image'] = $this->common->getImage($this->folder_user, $value['user']['image']);
    //                     if ($value['user']['price_list_id'] != null) {
    //                         $price = Price_List::where('id', $value['user']['price_list_id'])->first();
    //                         if ($price != null) {
    //                             $value['price_list_id'] =  $value['user']['price_list_id'];
    //                             $value['price'] = $price['amount'];
    //                             $value['android_product_package'] = $price['android_product_package'];
    //                             $value['ios_product_package'] = $price['ios_product_package'];
    //                             $value['web_product_package'] = $price['web_product_package'];
    //                         }
    //                     }
    //                 }
    //                 unset($value['user']);

    //                 $value['is_follow'] = $this->common->is_follow($value['to_user_id'], $user_id);
    //                 if ($value['is_follow'] == 1) {

    //                     // Remove User to Suggestion
    //                     unset($data[$key]);
    //                     Suggestion_User::where('id', $value['id'])->delete();
    //                 }
    //             }
    //             return $this->common->API_Response(200, __('api_msg.get_record_successfully'), $data, $pagination);
    //         } else {
    //             return $this->common->API_Response(400, __('api_msg.data_not_found'));
    //         }
    //     } catch (Exception $e) {
    //         return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
    //     }
    // }
    // public function remove_suggestion_user(Request $request)
    // {
    //     try {

    //         $validation = Validator::make(
    //             $request->all(),
    //             [
    //                 'user_id' => 'required|numeric',
    //                 'to_user_id' => 'required|numeric',
    //             ],
    //             [
    //                 'user_id.required' => __('api_msg.user_id_is_required'),
    //                 'to_user_id.required' => __('api_msg.to_user_id_is_required'),
    //             ]
    //         );
    //         if ($validation->fails()) {
    //             $data['status'] = 400;
    //             $data['message'] = $validation->errors()->first();
    //             return $data;
    //         }

    //         $user_id = $request['user_id'];
    //         $to_user_id = $request['to_user_id'];

    //         Suggestion_User::where('to_user_id', $user_id)->where('user_id', $to_user_id)->delete();

    //         return $this->common->API_Response(200, __('api_msg.suggestion_user_delete'));
    //     } catch (Exception $e) {
    //         return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
    //     }
    // }

    // Live User
    public function add_live_user(Request $request)
    {
        try {
            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required|numeric',
                    'room_id' => 'required',
                    'status' => 'required|numeric',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                    'room_id.required' => __('api_msg.room_id_is_required'),
                    'status.required' => __('api_msg.status_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $insert['user_id'] = $request->user_id;
            $insert['room_id'] = $request->room_id;
            $insert['total_view'] = 0;
            $insert['status'] = $request->status;

            Live_User::insertGetId($insert);

            return $this->common->API_Response(200, __('api_msg.user_live_successfully'));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function delete_live_user(Request $request)
    {
        try {
            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required|numeric',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            Live_User::where('user_id', $request->user_id)->delete();

            return $this->common->API_Response(200, __('api_msg.status_update_successfully'));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function list_of_live_users(Request $request)
    {
        try {

            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required|numeric',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $user_id = $request->user_id;
            $page_size = 0;
            $current_page = 0;
            $more_page = false;


            $data = Live_User::whereNotIn('user_id', [$user_id])->where('status', 1)->with('user')->latest();

            $total_rows = $data->count();
            $total_page = $this->page_limit;
            $page_size = ceil($total_rows / $total_page);
            $current_page = $request->page_no ?? 1;
            $offset = $current_page * $total_page - $total_page;
            $data->take($total_page)->offset($offset);

            $more_page = $this->common->more_page($current_page, $page_size);

            $data = $data->get();

            $pagination = $this->common->pagination_array($total_rows, $page_size, $current_page, $more_page);

            if (count($data) > 0) {
                foreach ($data as $key => $value) {

                    $value['user_name'] = "";
                    $value['full_name'] = "";
                    $value['email'] = "";
                    $value['mobile_number'] = "";
                    $value['image'] = asset('/assets/imgs/default.png');
                    $value['is_private'] = 0;
                    $value['is_creator'] = 1;
                    if ($value['user'] != null && isset($value['user'])) {
                        $value['user_name'] = $value['user']['user_name'];
                        $value['full_name'] = $value['user']['full_name'];
                        $value['email'] = $value['user']['email'];
                        $value['mobile_number'] = $value['user']['mobile_number'];
                        $value['image'] = $this->common->getImage($this->folder_user, $value['user']['image']);
                        $value['is_private'] = $value['user']['is_private'];
                    }
                    $value['is_buy'] = $this->common->is_any_package_buy($user_id, $value['user_id']);
                    unset($value['user']);
                }
                return $this->common->API_Response(200, __('api_msg.get_record_successfully'), $data, $pagination);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }

    // // Follower & Following
    // public function get_following_list(Request $request)
    // {
    //     try {

    //         $validation = Validator::make(
    //             $request->all(),
    //             [
    //                 'user_id' => 'required|numeric',
    //             ],
    //             [
    //                 'user_id.required' => __('api_msg.user_id_is_required'),
    //             ]
    //         );
    //         if ($validation->fails()) {
    //             $data['status'] = 400;
    //             $data['message'] = $validation->errors()->first();
    //             return $data;
    //         }

    //         $user_id = $request['user_id'];
    //         $page_size = 0;
    //         $current_page = 0;
    //         $more_page = false;

    //         $data = Follow::where('user_id', $user_id)->where('status', 1)->with('to_user')->latest();

    //         $total_rows = $data->count();
    //         $total_page = $this->page_limit;
    //         $page_size = ceil($total_rows / $total_page);
    //         $current_page = $request->page_no ?? 1;
    //         $offset = $current_page * $total_page - $total_page;
    //         $data->take($total_page)->offset($offset);

    //         $more_page = $this->common->more_page($current_page, $page_size);
    //         $pagination = $this->common->pagination_array($total_rows, $page_size, $current_page, $more_page);

    //         $data = $data->get();

    //         foreach ($data as $key => $value) {

    //             $value['user_name'] = "";
    //             $value['full_name'] = "";
    //             $value['email'] = "";
    //             $value['mobile_number'] = "";
    //             $value['image'] = asset('/assets/imgs/default.png');
    //             $value['is_private'] = 0;
    //             $value['is_creator'] = 0;
    //             $value['is_follow'] = 0;
    //             if ($value['to_user'] != null && isset($value['to_user'])) {
    //                 $value['user_name'] = $value['to_user']['user_name'];
    //                 $value['full_name'] = $value['to_user']['full_name'];
    //                 $value['email'] = $value['to_user']['email'];
    //                 $value['mobile_number'] = $value['to_user']['mobile_number'];
    //                 $value['image'] = $this->common->getImage($this->folder_user, $value['to_user']['image']);
    //                 $value['is_private'] = $value['to_user']['is_private'];
    //                 $value['is_creator'] = $value['to_user']['is_creator'];

    //                 // Is Follow
    //                 $is_follow = Follow::where('user_id', $user_id)->where('to_user_id', $value['to_user']['id'])->first();
    //                 if ($is_follow) {
    //                     $value['is_follow'] = 1;
    //                 }
    //             }

    //             // Is Buy 
    //             $value['is_buy'] = $this->common->is_any_package_buy($user_id);

    //             unset($value['to_user']);
    //         }

    //         return $this->common->API_Response(200, __('api_msg.get_record_successfully'), $data, $pagination);
    //     } catch (Exception $e) {
    //         return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
    //     }
    // }
    // public function get_follower_list(Request $request)
    // {
    //     try {

    //         $validation = Validator::make(
    //             $request->all(),
    //             [
    //                 'user_id' => 'required|numeric',
    //             ],
    //             [
    //                 'user_id.required' => __('api_msg.user_id_is_required'),
    //             ]
    //         );
    //         if ($validation->fails()) {
    //             $data['status'] = 400;
    //             $data['message'] = $validation->errors()->first();
    //             return $data;
    //         }

    //         $user_id = $request['user_id'];
    //         $page_size = 0;
    //         $current_page = 0;
    //         $more_page = false;

    //         $data = Follow::where('to_user_id', $user_id)->where('status', 1)->with('user')->latest();

    //         $total_rows = $data->count();
    //         $total_page = $this->page_limit;
    //         $page_size = ceil($total_rows / $total_page);
    //         $current_page = $request->page_no ?? 1;
    //         $offset = $current_page * $total_page - $total_page;
    //         $data->take($total_page)->offset($offset);

    //         $more_page = $this->common->more_page($current_page, $page_size);
    //         $pagination = $this->common->pagination_array($total_rows, $page_size, $current_page, $more_page);

    //         $data = $data->get();

    //         foreach ($data as $key => $value) {

    //             $value['user_name'] = "";
    //             $value['full_name'] = "";
    //             $value['email'] = "";
    //             $value['mobile_number'] = "";
    //             $value['image'] = asset('/assets/imgs/default.png');
    //             $value['is_private'] = 0;
    //             $value['is_creator'] = 0;
    //             $value['is_follow'] = 0;
    //             if ($value['user'] != null && isset($value['user'])) {
    //                 $value['user_name'] = $value['user']['user_name'];
    //                 $value['full_name'] = $value['user']['full_name'];
    //                 $value['email'] = $value['user']['email'];
    //                 $value['mobile_number'] = $value['user']['mobile_number'];
    //                 $value['image'] = $this->common->getImage($this->folder_user, $value['user']['image']);
    //                 $value['is_private'] = $value['user']['is_private'];
    //                 $value['is_creator'] = $value['user']['is_creator'];

    //                 // Is Follow
    //                 $is_follow = Follow::where('user_id', $user_id)->where('to_user_id', $value['user']['id'])->first();
    //                 if ($is_follow) {
    //                     $value['is_follow'] = 1;
    //                 }
    //             }

    //             // Is Buy 
    //             $value['is_buy'] = $this->common->is_any_package_buy($user_id);

    //             unset($value['user']);
    //         }

    //         return $this->common->API_Response(200, __('api_msg.get_record_successfully'), $data, $pagination);
    //     } catch (Exception $e) {
    //         return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
    //     }
    // }
}
