<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Creator_Package_Transaction extends Model
{
    use HasFactory;

    protected $table = 'tbl_creator_package_transaction';
    protected $guarded = array();

    protected $casts = [
        'id' => 'integer',
        'user_id' => 'integer',
        'to_user_id' => 'integer',
        'creator_package_id' => 'string',
        'price' => 'string',
        'transaction_id' => 'string',
        'description' => 'string',
        'expiry_date' => 'string',
        'status' => 'integer',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function creator()
    {
        return $this->belongsTo(User::class, 'to_user_id');
    }
    public function creator_package()
    {
        return $this->belongsTo(Creator_Package::class, 'creator_package_id');
    }
}
