@extends('admin.layout.page-app')
@section('page_title', __('Label.creator_transactions'))
@section('tab_title', __('Label.creator_transactions'))

@section('content')
    @include('admin.layout.sidebar')

    <!-- Select2 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" />

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm"> {{__('Label.creator_transactions')}} </h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('Label.Dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Label.creator_transactions')}}</li>
                    </ol>
                </div>
            </div>

            <!-- Export Files -->
            <div class="page-search mb-3">
                <div class="col-8">
                    <label class="text-gray pt-2 font-weight-bold"><i class="fa-solid fa-circle-info fa-2xl mr-3"></i>{{__('Label.only_the_following_data_will_be_captured_in_this_file')}}</label>
                </div>
                <div class="col-4">
                    <div class="d-flex justify-content-end">
                        <button id="ms_excel" class="btn btn-default" title="Download MS-Excel"><i class="fa-sharp fa-solid fa-file-excel mr-2 font-weight-bold"></i>{{__('Label.ms_excel')}}</button>
                    </div>
                </div>
            </div>

            <!-- Search -->
            <div class="page-search mb-3">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                            <i class="fa-solid fa-magnifying-glass fa-xl light-gray"></i>
                        </span>
                    </div>
                    <input type="text" id="input_search" class="form-control" placeholder="{{__('Label.search_by_transaction_id')}}" aria-label="Search" aria-describedby="basic-addon1">
                </div>
                <div class="sorting mr-3">
                    <label>{{__('Label.sort_by')}}</label>
                    <select class="form-control" id="input_type">
                        <option value="all">{{__('Label.all')}}</option>
                        <option value="today">{{__('Label.today')}}</option>
                        <option value="month">{{__('Label.month')}}</option>
                        <option value="year">{{__('Label.year')}}</option>
                    </select>
                </div>
                <div class="sorting mr-3">
                    <label>{{__('Label.sort_by')}}</label>
                    <select class="form-control" id="input_creator" style="width: 200px !important;">
                        <option value="all">{{__('Label.all_creator')}}</option>
                        @foreach($creator as $value)
                        <option value="{{$value->id}}">{{$value->full_name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="table-responsive table">
                <table class="table table-striped text-center table-bordered" id="datatable">
                    <thead>
                        <tr style="background: #F9FAFF;">
                            <th> {{__('Label.#')}} </th>
                            <th> {{__('Label.Image')}} </th>
                            <th> {{__('Label.User')}} </th>
                            <th> {{__('Label.Creator')}} </th>
                            <th> {{__('Label.creator_package')}} </th>
                            <th> {{__('Label.Price')}} </th>
                            <th> {{__('Label.transaction_id')}} </th>
                            <th> {{__('Label.Description')}} </th>
                            <th> {{__('Label.Date')}} </th>
                            <th> {{__('Label.expiry_date')}} </th>
                            <th> {{__('Label.Status')}} </th>
                            <th> {{__('Label.Action')}} </th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                    <tfoot>
                        <tr style="background: #F9FAFF;">
                            <td colspan="12" class="text-center"></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <!-- Select2 -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <!-- Export Files LInk (PDF, CSV, MS-Excel) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/vfs_fonts.js"></script>

    <script>
        // Sidebar Scroll Down
		sidebar_down($(document).height());
        $('#input_creator').select2();
        $('#input_user').select2();
        var defaultImagePath = "{{ asset('assets/imgs/default.png') }}";
        
        $(document).ready(function() {
            var table = $('#datatable').DataTable({
                ...dataTableDefaults,
                ajax: {
                    url: "{{ route('creator_transaction.index') }}",
                    data: function(d) {
                        d.input_type = $('#input_type').val();
                        d.input_search = $('#input_search').val();
                        d.input_creator = $('#input_creator').val();
                    },
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'user.image',
                        name: 'user.image',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, full, meta) {
                            if (data) {
                                return "<a href='" + data + "' target='_blank' title='Watch'><img src='" + data + "' class='rounded-circle' style='height:55px; width:55px'></a>";
                            } else {
                                return "<img src='" + defaultImagePath + "' class='rounded-circle' style='height:55px; width:55px'>";
                            }
                        },
                    },
                    {
                        data: 'user.full_name',
                        name: 'user.full_name',
                        orderable: false,
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        },
                    },
                    {
                        data: 'creator.full_name',
                        name: 'creator.full_name',
                        orderable: false,
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        },
                    },
                    {
                        data: 'creator_package.name',
                        name: 'creator_package.name',
                        orderable: false,
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        },
                    },
                    {
                        data: 'price',
                        name: 'price',
                        render: function(data) {
                            return data ? data : 0;
                        }
                    },
                    {
                        data: 'transaction_id',
                        name: 'transaction_id',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        },
                    },
                    {
                        data: 'description',
                        name: 'description',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        },
                    },
                    {
                        data: 'date',
                        name: 'date',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'expiry_date',
                        name: 'expiry_date',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'status',
                        name: 'status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                buttons: [{
                        extend: 'excel',
                        filename: "{{App_Name()}} - {{__('Label.Transactions')}}",
                        exportOptions: {
                            columns: [0, 2, 3, 4, 5, 6, 8, 9, 10]
                        },
                        customize: function(xlsx) {
                            var sheet = xlsx.xl.worksheets['sheet1.xml'];
                            $('row:first c', sheet).attr('s', '2');
                        },
                    },
                    {
                        extend: 'csv',
                        filename: "{{App_Name()}} - {{__('Label.Transactions')}}",
                        exportOptions: {
                            columns: [0, 2, 3, 4, 5, 6, 8, 9, 10]
                        },
                    },
                   
                ],
                footerCallback: function ( row, data, start, end, display ) {
                    var api = this.api(), data;

                    // converting to interger to find total
                    var intVal = function ( i ) {
                        return typeof i === 'string' ? i.replace(/[\$,]/g, '')*1 : typeof i === 'number' ? i : 0;
                    };

                    // computing column Total of the complete result 
                    var Total = api
                        .column(5)
                        .data()
                        .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                        }, 0 );

                    // Update footer by showing the total with the reference of the column index 
                    $(api.column(1).footer() ).html("Total Amount =&nbsp &nbsp {{Currency_Code() }}"+ " " + Total);
                },
            });

            $('#ms_excel').on('click', function() {

                var check_access = '{{Check_Admin_Access()}}';
                if (check_access == 1) {
                    var table = $('#datatable').DataTable();
                    table.button('0').trigger();
                } else {
                    toastr.error("{{__('Label.you_have_no_right_to_download_this_files')}}");
                }
            });

            $('#input_type, #input_creator').change(function() {
                table.draw();
            });
            $('#input_search').keyup(function() {
                table.draw();
            });
        });
    </script>
@endsection