@extends('admin.layout.page-app')
@section('page_title', __('Label.gift'))
@section('tab_title', __('Label.gift'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('Label.gift')}}</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('Label.Dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Label.gift')}}</li>
                    </ol>
                </div>
            </div>

            <!-- Add Gift -->
            <div class="card custom-border-card mt-3">
                <h5 class="card-header">{{__('Label.add_gift')}}</h5>
                <div class="card-body">
                    <form id="gift" enctype="multipart/form-data"  autocomplete="off">
                        <input type="hidden" name="id" value="">
                        <div class="form-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label> {{__('Label.Name')}}<span class="text-danger">*</span></label>
                                    <input type="text" name="name" class="form-control" placeholder="{{__('Label.enter_name')}}" autofocus>
                                </div>
                                <div class="form-group">
                                    <label> {{__('Label.coin')}}<span class="text-danger">*</span></label>
                                    <input type="number" name="coin" min="0" class="form-control" placeholder="{{__('Label.enter_coin')}}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group ml-4">
                                    <div class="form-group">
                                        <label>{{__('Label.Image')}}<span class="text-danger">*</span></label>
                                        <input type="file" class="form-control import-file" name="image" accept=".svga">
                                        <label class="mt-3 ml-2 text-gray">{{__('Label.only_svga_file_max_size')}}</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="border-top pt-3 text-right">
                            <button type="button" class="btn btn-default mw-120" onclick="save_gift()">{{__('Label.SAVE')}}</button>
                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        </div>
                    </form>
                </div>
            </div>

            <!-- Search & Table-->
            <div class="card custom-border-card mt-3">
                <div class="page-search mb-3">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1"><i class="fa-solid fa-magnifying-glass fa-xl light-gray"></i></span>
                        </div>
                        <input type="text" id="input_search" class="form-control" placeholder="{{__('Label.search_gift')}}" aria-label="Search" aria-describedby="basic-addon1">
                    </div>
                </div>

                <div class="table-responsive table">
                    <table class="table table-striped text-center table-bordered" id="datatable">
                        <thead>
                            <tr style="background: #F9FAFF;">
                                <th> {{__('Label.#')}} </th>
                                <th> {{__('Label.Image')}} </th>
                                <th> {{__('Label.Name')}} </th>
                                <th> {{__('Label.coin')}} </th>
                                <th> {{__('Label.Action')}} </th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>

            <!-- Edit Model -->
            <div class="modal fade" id="EditModel" tabindex="-1" data-backdrop="static" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">{{__('Label.edit_gift')}}</h5>
                            <button type="button" class="close text-dark" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form id="edit_gift" autocomplete="off" autocomplete="off">
                            <div class="modal-body">
                                <div class="form-row">
                                    <div class="col-md-7">
                                        <div class="form-row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>{{__('Label.Name')}}<span class="text-danger">*</span></label>
                                                    <input type="text" name="name" id="edit_name" class="form-control" placeholder="{{__('Label.enter_name')}}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>{{__('Label.coin')}}<span class="text-danger">*</span></label>
                                                    <input type="number" name="coin" id="edit_coin" class="form-control" placeholder="{{__('Label.enter_coin')}}" min="0">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <div class="form-group ml-3">
                                            <label>{{__('Label.Image')}}</label>
                                            <input type="file" class="form-control import-file" name="image" accept=".svga">
                                            <label class="mt-3 ml-2 mr-5 text-gray">{{__('Label.only_svga_file_max_size')}}</label>
                                            <a href="" target="_blank" id="edit_preview_image" class="btn-link ml-2"></a>
                                        </div>
                                    </div>
                                </div>
                                <input type="hidden" name="id" id="edit_id">
                                <input type="hidden" name="old_image" id="edit_old_image">
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default mw-120" onclick="update_gift()">{{__('Label.UPDATE')}}</button>
                                <button type="button" class="btn btn-cancel mw-120" data-dismiss="modal">{{__('Label.close')}}</button>
                                <input type="hidden" name="_method" value="PATCH">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <script>
        $(document).ready(function() {
            var table = $('#datatable').DataTable({
                ...dataTableDefaults,
                ajax: {
                    url: "{{ route('gift.index') }}",
                    data: function(d) {
                        d.input_search = $('#input_search').val();
                    },
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'image',
                        name: 'image',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, full, meta) {
                            if (!data) return '';

                            var fileName = data.split('/').pop(); // extract base name

                            return "<a href='" + data + "' target='_blank' class='btn-link'>" + fileName + "</a>";
                        },
                    },
                    {
                        data: 'name',
                        name: 'name',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'coin',
                        name: 'coin',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
            });

            $('#input_search').keyup(function() {
                table.draw();
            });
        });

        function save_gift(){
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                $("#dvloader").show();
                var formData = new FormData($("#gift")[0]);
                $.ajax({
                    type:'POST',
                    url:'{{ route("gift.store") }}',
                    data:formData,
                    cache:false,
                    contentType: false,
                    processData: false,
                    success:function(resp){
                        $("#dvloader").hide();
                        get_responce_message(resp, 'gift', '{{ route("gift.index") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);         
                    }
                });
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
		}

        $(document).on("click", ".edit_gift", function() {
            var id = $(this).data('id');
            var name = $(this).data('name');
            var coin = $(this).data('coin');
            var image = $(this).data('image');

            var basename = image.split('/').pop(); // extract filename from URL
            $(".modal-body #edit_id").val(id);
            $(".modal-body #edit_name").val(name);
            $(".modal-body #edit_coin").val(coin);
            $(".modal-body #edit_old_image").val(image);
            $(".modal-body #edit_preview_image").attr("href", image).text(basename);
        });

        function update_gift(){
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                $("#dvloader").show();
                var formData = new FormData($("#edit_gift")[0]);

                var Edit_Id = $("#edit_id").val();
                var url = '{{ route("gift.update", ":id") }}';
                    url = url.replace(':id', Edit_Id);

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    enctype: 'multipart/form-data',
                    type: 'POST',
                    url: url,
                    data: formData,
                    cache:false,
                    contentType: false,
                    processData: false,
                    success:function(resp){
                        $("#dvloader").hide();

                        if(resp.status == 200){
                            $('#EditModel').modal('toggle');
                        }
                        get_responce_message(resp, 'edit_gift', '{{ route("gift.index") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);         
                    }
                });
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
		}
    </script>
@endsection