@extends('admin.layout.page-app')
@section('page_title', __('Label.edit_story'))
@section('tab_title', __('Label.edit_story'))

@section('content')
    @include('admin.layout.sidebar')

    <!-- Select2 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" />

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('Label.edit_story')}}</h1>
            <div class="border-bottom row mb-3">
                <div class="col-sm-10">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">{{__('Label.Dashboard')}}</a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('story.index') }}">{{__('Label.story')}}</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            {{__('Label.edit_story')}}
                        </li>
                    </ol>
                </div>
                <div class="col-sm-2 d-flex align-items-center justify-content-end">
                    <a href="{{ route('story.index') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Label.story_list')}}</a>
                </div>
            </div>

            <div class="card custom-border-card">
                <form enctype="multipart/form-data" id="story" autocomplete="off">
                    <input type="hidden" name="id" value="@if($data){{$data->id}}@endif">
                    <input type="hidden" name="old_url" value="@if($data){{$data->url}}@endif">
                    <input type="hidden" name="old_video_url" value="@if($data->type == 'video'){{{$data->url}}}@endif">
                    <div class="form-row">
                        <div class="col-md-9">
                            <div class="form-row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{__('Label.Creator')}}<span class="text-danger">*</span></label>
                                        <select class="form-control" style="width:100%!important;" name="user_id" id="user_id">
                                            <option value="">{{__('Label.select_creator')}}</option>
                                            @foreach ($creator as $key => $value)
                                            <option value="{{ $value->id}}" {{$value->id == $data->user_id ? 'selected' : ''}}>
                                                {{ $value->full_name }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{__('Label.Type')}}<span class="text-danger">*</span></label>
                                        <select class="form-control" name="type" id="type">
                                            <option value="video" {{ $data->type == "video" ? 'selected' : ''}}>{{__('Label.Video')}}</option>
                                            <option value="image" {{ $data->type == "image" ? 'selected' : ''}}>{{__('Label.Image')}} </option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-12 video_box_type">
                                    <div class="form-row">
                                        <div class="form-group col-lg-12 video_box">
                                            <div style="display: block;">
                                                <label for="input-1">{{__('Label.Upload_Video')}}<span class="text-danger">*</span></label>
                                                <div id="filelist_story"></div>
                                                <div id="container_story" style="position: relative;">
                                                    <div class="form-group d-flex align-items-center">
                                                        <input type="file" id="uploadFile_story" name="uploadFile_story" class="form-control import-file mr-4">
                                                        <a id="upload_story" class="btn text-white py-2" style="background-color:#4e45b8;">{{__('Label.Upload_Files')}}</a>
                                                    </div>
                                                    <input type="hidden" name="video" id="mp3_file_name_story" class="form-control">
                                                    <div class="form-group">
                                                        <label class="text-gray">@if($data->type == 'video'){{{$data->url}}}@endif</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>{{__('Label.Description')}}<span class="text-danger">*</span></label>
                                        <textarea name="description" class="form-control" id="summernote">@if($data){{$data->description}}@endif</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 image-box">
                            <div class="form-group ml-5">
                                <label class="ml-5">{{__('Label.Image')}}<span class="text-danger">*</span></label>
                                <div class="avatar-upload ml-5">
                                    <div class="avatar-edit">
                                        <input type='file' name="image" id="imageUpload" accept=".png, .jpg, .jpeg" />
                                        <label for="imageUpload" title="Select File"></label>
                                    </div>
                                    <div class="avatar-preview">
                                        <img src="@if($data->type == 'image'){{{$data->url}}}@else{{asset('assets/imgs/upload_img.png')}}@endif" alt="no_img.png" id="imagePreview">
                                    </div>
                                </div>
                                <input type="hidden" name="old_image" value="@if($data->type == 'image'){{{$data->url}}}@endif">
                                <label class="mt-3 ml-5 text-gray">{{__('Label.maximum_size')}}</label>
                            </div>
                        </div>
                    </div>

                    <div class="border-top mt-2 pt-3 text-right">
                        <button type="button" class="btn btn-default mw-120" onclick="update_story()">{{__('Label.UPDATE')}}</button>
                        <a href="{{route('story.index')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
                        <input type="hidden" name="_method" value="PATCH">
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <!-- Select2 -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <!-- Chunk JS -->
    <script src="{{ asset('/assets/js/plupload.full.min.js')}}"></script>
    <script src="{{ asset('/assets/js/common.js')}}"></script>

    <script>
        $("#user_id").select2();

        var type = "<?php echo $data->type; ?>";
        if (type == "video") {
            $(".video_box").show();
            $(".image-box").hide();
        } else {
            $(".image-box").show();
            $(".video_box").hide();
        }

        $('#type').change(function() {
            var optionValue = $(this).val();

            if (optionValue == 'video') {
                $(".video_box").show();
                $(".image-box").hide();
            } else {
                $(".image-box").show();
                $(".video_box").hide();

            }
        });

        function update_story() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){
                $("#dvloader").show();
                var formData = new FormData($("#story")[0]);
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type: 'POST',
                    url: '{{ route("story.update" ,[$data->id]) }}',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'story', '{{ route("story.index") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
        }
    </script>
@endsection