@extends('admin.layout.page-app')
@section('page_title', __('Label.story'))
@section('tab_title', __('Label.story'))

@section('content')
    @include('admin.layout.sidebar')

    <!-- Select2 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" />

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('Label.story')}} </h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('Label.Dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Label.story')}}</li>
                    </ol>
                </div>
            </div>

            <!-- Search -->
            <form action="{{ route('story.index')}}" method="GET">
                <div class="page-search">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" id="basic-addon1">
                                <i class="fa-solid fa-magnifying-glass fa-xl light-gray"></i>
                            </span>
                        </div>
                        <input type="text" name="input_search" value="@if(isset($_GET['input_search'])){{$_GET['input_search']}}@endif" class="form-control" placeholder="{{__('Label.search_story')}}" aria-label="Search" aria-describedby="basic-addon1" autocomplete="off">
                    </div>
                    @if(isset($creator))
                    <div class="sorting mr-4" style="width: 60% !important;">
                        <label>{{__('Label.sort_by')}}</label>
                        <select class="form-control" name="input_creator" id="creator_id" >
                            <option value="all" selected>{{__('Label.all_creator')}}</option>
                            @for ($i = 0; $i < count($creator); $i++) <option value="{{ $creator[$i]['id'] }}" @if(isset($_GET['input_creator'])){{ $_GET['input_creator'] == $creator[$i]['id'] ? 'selected' : ''}} @endif>
                                {{ $creator[$i]['full_name'] }}
                                </option>
                                @endfor
                        </select>
                    </div>
                    @endif
                    <div class="">
                        <button class="btn btn-default w-100" type="submit">{{__('Label.search')}}</button>
                    </div>
                </div>
            </form>

            <div class="row">
                <div class="col-12 col-sm-6 col-md-4 col-xl-3">
                    <a href="{{ route('story.create') }}" class="add-video-btn">
                        <i class="fa-regular fa-square-plus fa-3x icon" style="color: #818181;"></i>
                        {{__('Label.add_story')}}
                    </a>
                </div>

                @foreach ($data as $key => $value)
                <div class="col-12 col-sm-6 col-md-4 col-xl-3">
                    <div class="card video-card">
                        <div class="position-relative">
                            @if($value->type == "video")
                            <img class="card-img-top" src="{{asset('assets/imgs/no_img.png')}}" alt="">
                            <button class="btn play-btn-top video" data-toggle="modal" data-target="#videoModal" data-video="{{$value->url}}" data-image="{{$value->url}}">
                                <i class="fa-regular fa-circle-play text-white fa-4x mr-2 mt-2"></i>
                            </button>
                            @else
                            <img class="card-img-top" src="{{$value->url}}" alt="">
                            @endif
                            <ul class="list-inline overlap-control" aria-labelledby="dropdownMenuLink">
                                <li class="list-inline-item">
                                    <a class="btn" href="{{route('story.edit', [$value->id])}}" title="Edit">
                                        <i class="fa-solid fa-pen-to-square fa-xl" class="dot-icon" style="color: #4e45b8;"></i>
                                    </a>
                                </li>
                                <li class="list-inline-item">
                                    <a class="btn" href="{{route('story.show', [$value->id])}}" title="Delete" onclick="return confirm('{{__('Label.delete_story')}}')">
                                        <i class="fa-solid fa-trash-can fa-xl" class="dot-icon" style="color: #4e45b8;"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="card-body">
                            <h5 class="card-title">{!! htmlspecialchars_decode($value->description) !!}</h5>
                            <div class="d-flex justify-content-between">
                                @if($value->status == 1)
                                <button class="btn btn-sm" id="{{$value->id}}" onclick="change_status('{{ $value->id }}', '{{ $value->status }}')" style="background:#058f00; color:#fff; font-weight:bold; border:none">{{__('Label.show')}}</button>
                                @elseif($value->status == 0)
                                <button class="btn btn-sm" id="{{$value->id}}" onclick="change_status('{{ $value->id }}', '{{ $value->status }}')" style="background:#e3000b; color:#fff; font-weight:bold; border:none">{{__('Label.hide')}}</button>
                                @endif
                                <span class="d-flex text-align-center">
                                    <i class="fa-regular fa-eye fa-xl mr-2" style="color:#4e45b8; margin-top:12px"></i>
                                    <h5 class="counting" data-count="{{No_Format($value->total_view ?? 0)}}">{{No_Format($value->total_view)}}</h5>
                                </span>
                            </div>
                            <div class="d-flex justify-content-start mt-1 mb-0">
                                <span class="article-blog-time ">{{ date('Y-m-d', strtotime($value->created_at)) }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach

                <div class="modal fade" id="videoModal" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-lg">
                        <div class="modal-content">
                            <div class="modal-body p-0 bg-transparent">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true" class="text-dark">&times;</span>
                                </button>
                                <video controls width="800" height="500" preload='none' poster="" id="theVideo" controlsList="nodownload noplaybackrate" disablepictureinpicture>
                                    <source src="">
                                </video>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-between align-items-center">
                <div> Showing {{ $data->firstItem() }} to {{ $data->lastItem() }} of total {{$data->total()}} entries </div>
                <div class="pb-5"> {{ $data->links('pagination::bootstrap-4') }} </div>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <!-- Select2 -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

    <script>
        $("#creator_id").select2();
        $(function() {
            $(".video").click(function() {
                var theModal = $(this).data("target"),
                    videoSRC = $(this).attr("data-video"),
                    videoPoster = $(this).attr("data-image"),
                    videoSRCauto = videoSRC + "";

                $(theModal + ' source').attr('src', videoSRCauto);
                $(theModal + ' video').attr('poster', videoPoster);
                $(theModal + ' video').load();
                $(theModal + ' button.close').click(function() {
                    $(theModal + ' source').attr('src', videoSRC);
                });
            });
        });

        $("#videoModal .close").click(function() {
            theVideo.pause()
        });

        function change_status(id, status) {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                $("#dvloader").show();
                var url = "{{route('story.status', '')}}" + "/" + id;
                $.ajax({
                    type: "GET",
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: id,
                    success: function(resp) {
                        $("#dvloader").hide();

                        if (resp.status == 200) {

                            if (resp.Status == 1) {
                                $('#' + id).text("{{__('Label.show')}}");
                                $('#' + id).css({
                                    "background": "#058f00",
                                    "color": "white",
                                    "font-weight": "bold",
                                    "border": "none"
                                });
                            } else {
                                $('#' + id).text("{{__('Label.hide')}}");
                                $('#' + id).css({
                                    "background": "#e3000b",
                                    "color": "white",
                                    "font-weight": "bold",
                                    "border": "none"
                                });
                            }
                        } else {
                            toastr.error(resp.errors);
                        }

                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
                
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
        };
    </script>
@endsection