@extends('admin.layout.page-app')
@section('page_title', __('Label.system_settings'))
@section('tab_title', __('Label.system_settings'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">

            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('Label.system_settings')}}</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('Label.Dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Label.system_settings')}}</li>
                    </ol>
                </div>
            </div>

            <div class="row">
                <div class="col-6">
                    <div class="card custom-border-card">
                        <a data-bs-toggle="collapse" data-bs-target="#clear_data">
                            <h5 class="card-header"><i class="fa-solid fa-chevron-down float-right"></i>{{__('Label.clear_cache')}}</h5>
                        </a>

                        <div id="clear_data" class="collapse">
                            <div class="card-body">
                                <p>{{__('Label.this_means_that_the_extra_uploaded_files_in_your_system_will_be_deleted')}}</p>
                                <div class="d-flex justify-content-end">
                                    <button type="button" class="btn btn-default mw-120" onclick="clear_data()">{{__('Label.clear_cache')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="card custom-border-card">
                        <a data-bs-toggle="collapse" data-bs-target="#download_database">
                            <h5 class="card-header"><i class="fa-solid fa-chevron-down float-right"></i>{{__('Label.backup_database')}}</h5>
                        </a>

                        <div id="download_database" class="collapse">
                            <div class="card-body">
                                <p>{{__('Label.download_the_sql_file_of_the_current_database')}}</p>
                                <div class="d-flex justify-content-end">
                                    <a href="{{ route('system.setting.downloadsqlfile') }}" onclick="return confirm('{{ __('Label.you_want_to_download_this_sql_file') }}')" class="btn btn-default mw-120">{{__('Label.download')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-6">
                    <div class="card custom-border-card">
                        <a data-bs-toggle="collapse" data-bs-target="#clean_database">
                            <h5 class="card-header"><i class="fa-solid fa-chevron-down float-right"></i>{{__('Label.clean_database')}}</h5>
                        </a>

                        <div id="clean_database" class="collapse">
                            <div class="card-body">
                                <p>{{__('Label.dalete_all_data_in_database')}}</p>
                                <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-default mw-120" onclick="clean_database()">{{__('Label.clean_database')}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <script>

        // Sidebar Scroll Down
        let sidebarHeight = $('.sidebar')[0].scrollHeight;
        sidebar_down(sidebarHeight);

        function clear_data() {
            if (confirm('Do you confirm Clear the Data !!!')) {

                $("#dvloader").show();
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    enctype: 'multipart/form-data',
                    type: 'POST',
                    url: '{{ route("system.setting.cleardata") }}',
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, '', '{{ route("system.setting.index") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            }
        }
        function clean_database() {

            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                if (confirm('Do you confirm Clean the Database !!!')) {

                    $("#dvloader").show();
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        enctype: 'multipart/form-data',
                        type: 'POST',
                        url: '{{ route("system.setting.cleandatabase") }}',
                        cache: false,
                        contentType: false,
                        processData: false,
                        success: function(resp) {
                            $("#dvloader").hide();
                            get_responce_message(resp, '', '{{ route("system.setting.index") }}');
                        },
                        error: function(XMLHttpRequest, textStatus, errorThrown) {
                            $("#dvloader").hide();
                            toastr.error(errorThrown, textStatus);
                        }
                    });
                }
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
        }
    </script>
@endsection