@extends('admin.layout.page-app')
@section('page_title', __('Label.Users'))
@section('tab_title', __('Label.Users'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm"> {{__('Label.Users')}} </h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-10">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('Label.Dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Label.Users')}}</li>
                    </ol>
                </div>
                <div class="col-sm-2 d-flex align-items-center justify-content-end">
                    <a href="{{ route('user.create') }}" class="btn btn-default mw-120" style="margin-top: -14px;">{{__('Label.Add_User')}}</a>
                </div>
            </div>

            <!-- Export Files -->
            <div class="page-search mb-3">
                <div class="col-8">
                    <label class="text-gray pt-2 font-weight-bold"><i class="fa-solid fa-circle-info fa-2xl mr-3"></i>{{__('Label.only_the_following_data_will_be_captured_in_this_file')}}</label>
                </div>
                <div class="col-4">
                    <div class="d-flex justify-content-around">
                        <button id="ms_excel" class="btn btn-default" title="Download MS-Excel"><i class="fa-sharp fa-solid fa-file-excel mr-2 font-weight-bold"></i>{{__('Label.ms_excel')}}</button>
                        <button id="csv" class="btn btn-default" title="Download CSV"><i class="fa-solid fa-file-csv mr-2 font-weight-bold" style="font-size:18px"></i>{{__('Label.csv')}}</button>
                        <button id="pdf" class="btn btn-default" title="Download PDF"><i class="fa-solid fa-file-pdf mr-2 font-weight-bold" style="font-size:18px"></i>{{__('Label.pdf')}}</button>
                    </div>
                </div>
            </div>

            <!-- Search -->
            <div class="page-search mb-3">
                <div class="input-group" title="Search">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1"><i class="fa-solid fa-magnifying-glass fa-xl light-gray"></i></span>
                    </div>
                    <input type="text" id="input_search" class="form-control" placeholder="{{__('Label.search_users')}}" aria-label="Search" aria-describedby="basic-addon1">
                </div>
                <div class="sorting mr-4">
                    <label>{{__('Label.sort_by')}}</label>
                    <select class="form-control" id="input_type">
                        <option value="all">{{__('Label.all')}}</option>
                        <option value="today">{{__('Label.today')}}</option>
                        <option value="month">{{__('Label.month')}}</option>
                        <option value="year">{{__('Label.year')}}</option>
                    </select>
                </div>
                <div class="sorting">
                    <label>{{__('Label.sort_by')}}</label>
                    <select class="form-control" id="input_login_type">
                        <option value="all">{{__('Label.all_type')}}</option>
                        <option value="1">{{__('Label.otp')}}</option>
                        <option value="2">{{__('Label.google')}}</option>
                        <option value="3">{{__('Label.apple')}}</option>
                        <option value="4">{{__('Label.normal')}}</option>
                    </select>
                </div>
            </div>

            <div class="table-responsive table">
                <table class="table table-striped text-center table-bordered" id="datatable">
                    <thead>
                        <tr style="background: #F9FAFF;">
                            <th> {{__('Label.#')}} </th>
                            <th> {{__('Label.Image')}} </th>
                            <th> {{__('Label.Full_Name')}} </th>
                            <th> {{__('Label.Email')}} </th>
                            <th> {{__('Label.Mobile')}} </th>
                            <th> {{__('Label.register_date')}} </th>
                            <th> {{__('Label.coin_wallet')}} </th>
                            <th> {{__('Label.Type')}} </th>
                            <th> {{__('Label.login_type')}} </th>
                            <th> {{__('Label.Action')}} </th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <!-- Export Files LInk (PDF, CSV, MS-Excel) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.32/vfs_fonts.js"></script>
    
    <script>
        $(document).ready(function() {
            var table = $('#datatable').DataTable({
                ...dataTableDefaults,
                ajax:
                    {
                    url: "{{ route('user.index') }}",
                    data: function(d){
                        d.input_type = $('#input_type').val();
                        d.input_login_type = $('#input_login_type').val();
                        d.input_search = $('#input_search').val();
                    },
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'image',
                        name: 'image',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, full, meta) {
                            return "<a href='" + data + "' target='_blank' title='Watch'><img src='" + data + "' class='rounded-circle' style='height:55px; width:55px'></a>";
                        },
                    },
                    {
                        data: 'full_name',
                        name: 'full_name',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'email',
                        name: 'email',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'mobile_number',
                        name: 'mobile_number',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return full.country_code + " " + full.mobile_number;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'date',
                        name: 'date'
                    },
                    {
                        data: 'coin_wallet',
                        name: 'coin_wallet',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "0";
                            }
                        }
                    },
                    {
                        data: 'type',
                        name: 'type',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, full, meta) {
                            if (data == 1) {
                                return "<i class='fa-solid fa-mobile-screen-button fa-3x' title='OTP Login'></i>";
                            } else if (data == 2) {
                                return "<i class='fa-brands fa-google fa-3x' title='Goggle Login'></i>";
                            } else if (data == 3) {
                                return "<i class='fa-brands fa-apple fa-3x' title='Apple Login'></i>";
                            } else if (data == 4) {
                                return "<i class='fa-solid fa-lock fa-3x' title='Normal Login'></i>";
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'type',
                        name: 'Login Type',
                        orderable: false,
                        searchable: false,
                        visible: false,
                        render: function(data, type, full, meta) {
                            if (data == 1) {
                                return "{{__('Label.otp')}}";
                            } else if (data == 2) {
                                return "{{__('Label.google')}}";
                            } else if (data == 3) {
                                return "{{__('Label.apple')}}";
                            } else if (data == 4) {
                                return "{{__('Label.normal')}}";
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                buttons: [{
                        extend: 'excel',
                        filename: "{{App_Name()}} - {{__('Label.Users')}}",
                        exportOptions: {
                            columns: [0, 2, 3, 4, 5, 8]
                        },
                        customize: function(xlsx) {
                            var sheet = xlsx.xl.worksheets['sheet1.xml'];
                            $('row:first c', sheet).attr('s', '2');
                        },
                    },
                    {
                        extend: 'csv',
                        filename: "{{App_Name()}} - {{__('Label.Users')}}",
                        exportOptions: {
                            columns: [0, 2, 3, 4, 5, 8]
                        },
                    },
                    {
                        extend: 'pdf',
                        title: "{{App_Name()}} - {{__('Label.Users')}}",
                        filename: "{{App_Name()}} - {{__('Label.Users')}}",
                        pageSize: 'A4',
                        exportOptions: {
                            columns: [0, 2, 3, 4, 5, 8]
                        },
                        customize: function(doc) {
                            doc.styles.tableHeader.fontSize = 10; //2, 3, 4, etc
                            doc.defaultStyle.fontSize = 8; //2, 3, 4,etc
                            doc.content[1].table.widths = ['3%', '17%', '20%', '20%', '20%', '20%'];
                            doc.content[1].layout = "borders";
                            doc.styles.title.fontSize = 22;
                            doc.styles.title.alignment = 'center';
                            doc.defaultStyle.alignment = 'center';

                            // Create a header
                            doc['header'] = (function(page, pages) {
                                return {
                                    columns: [{
                                            alignment: 'left',
                                            bold: true,
                                            text: "{{App_Name()}}",
                                        },
                                        {
                                            alignment: 'right',
                                            bold: true,
                                            text: ['Total Page ', {
                                                text: pages.toString()
                                            }],
                                        }
                                    ],
                                    margin: [20, 20],
                                }
                            });
                            // Create a footer
                            doc['footer'] = (function(page, pages) {
                                return {
                                    columns: [{
                                        alignment: 'center',
                                        bold: true,
                                        text: ['Page ', {
                                            text: page.toString()
                                        }, ' of ', {
                                            text: pages.toString()
                                        }],
                                    }],
                                }
                            });
                        }
                    }
                ],
            });

            $('#ms_excel').on('click', function() {

                var check_access = '{{Check_Admin_Access()}}';
                if (check_access == 1) {
                    var table = $('#datatable').DataTable();
                    table.button('0').trigger();
                } else {
                    toastr.error("{{__('Label.you_have_no_right_to_download_this_files')}}");
                }
            });
            $('#csv').on('click', function() {

                var check_access = '{{Check_Admin_Access()}}';
                if (check_access == 1) {
                    var table = $('#datatable').DataTable();
                    table.button('1').trigger();
                } else {
                    toastr.error("{{__('Label.you_have_no_right_to_download_this_files')}}");
                }
            });
            $('#pdf').on('click', function() {

                var check_access = '{{Check_Admin_Access()}}';
                if (check_access == 1) {
                    var table = $('#datatable').DataTable();
                    table.button('2').trigger();
                } else {
                    toastr.error("{{__('Label.you_have_no_right_to_download_this_files')}}");
                }
            });

            $('#input_type, #input_login_type').change(function(){
                table.draw();
            });
            $('#input_search').keyup(function(){
                table.draw();
            });
        });
    </script>
@endsection