<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\HomeController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['middleware' => 'installation'], function () {

    // --------------------- UserController ---------------------
    Route::post('registration', [UserController::class, 'registration']);
    Route::post('login', [UserController::class, 'login']);
    Route::post('account_verify', [UserController::class, 'account_verify']);
    Route::post('get_profile', [UserController::class, 'get_profile']);
    Route::post('update_profile', [UserController::class, 'update_profile']);
    Route::post('become_creator', [UserController::class, 'become_creator']);
    Route::post('search_user', [UserController::class, 'search_user']);
    Route::post('add_remove_user_block', [UserController::class, 'add_remove_user_block']);
    Route::post('user_block_list', [UserController::class, 'user_block_list']);
    Route::post('add_live_user', [UserController::class, 'add_live_user']);
    Route::post('delete_live_user', [UserController::class, 'delete_live_user']);
    Route::post('list_of_live_users', [UserController::class, 'list_of_live_users']);

    // Not Used
    // Route::post('search_history', [UserController::class, 'search_history']);
    // Route::post('add_search_user', [UserController::class, 'add_search_user']);
    // Route::post('remove_search_user', [UserController::class, 'remove_search_user']);
    // Route::post('clear_search_history', [UserController::class, 'clear_search_history']);
    // Route::post('suggestion_user_list', [UserController::class, 'suggestion_user_list']);
    // Route::post('remove_suggestion_user', [UserController::class, 'remove_suggestion_user']);
    // Route::post('get_following_list', [UserController::class, 'get_following_list']);
    // Route::post('get_follower_list', [UserController::class, 'get_follower_list']);

    // -------------------- HomeController --------------------
    Route::post('general_setting', [HomeController::class, 'general_setting']);
    Route::post('get_payment_option', [HomeController::class, 'get_payment_option']);
    Route::post('get_pages', [HomeController::class, 'get_pages']);
    Route::post('get_social_links', [HomeController::class, 'get_social_links']);
    Route::post('get_onboarding_screen', [HomeController::class, 'get_onboarding_screen']);
    Route::post('get_coin_package', [HomeController::class, 'get_coin_package']);
    Route::post('get_creator_package', [HomeController::class, 'get_creator_package']);
    Route::post('add_coin_transaction', [HomeController::class, 'add_coin_transaction']);
    Route::post('get_coin_transaction_list', [HomeController::class, 'get_coin_transaction_list']);
    Route::post('get_gift', [HomeController::class, 'get_gift']);
    Route::post('get_user_gift', [HomeController::class, 'get_user_gift']);
    Route::post('add_amount_wallet', [HomeController::class, 'add_amount_wallet']);
    Route::post('buy_gift', [HomeController::class, 'buy_gift']);
    Route::post('add_creator_package', [HomeController::class, 'add_creator_package']);
    Route::post('edit_creator_package', [HomeController::class, 'edit_creator_package']);
    Route::post('delete_creator_package', [HomeController::class, 'delete_creator_package']);
    Route::post('add_creator_package_transaction', [HomeController::class, 'add_creator_package_transaction']);
    Route::post('get_creator_package_transaction_list', [HomeController::class, 'get_creator_package_transaction_list']);
    Route::post('get_earning_list', [HomeController::class, 'get_earning_list']);
    Route::post('get_price_list', [HomeController::class, 'get_price_list']);
    Route::post('get_wallettransaction_list', [HomeController::class, 'get_wallettransaction_list']);
    Route::post('get_user_story', [HomeController::class, 'get_user_story']);
    Route::post('upload_story', [HomeController::class, 'upload_story']);
    Route::post('get_story', [HomeController::class, 'get_story']);
    Route::post('delete_story', [HomeController::class, 'delete_story']);
    Route::post('add_story_view', [HomeController::class, 'add_story_view']);
    Route::post('follow_unfollow', [HomeController::class, 'follow_unfollow']);
    Route::post('like_unlike', [HomeController::class, 'like_unlike']);
    Route::post('add_comment', [HomeController::class, 'add_comment']);
    Route::post('view_comment', [HomeController::class, 'view_comment']);
    Route::post('edit_comment', [HomeController::class, 'edit_comment']);
    Route::post('delete_comment', [HomeController::class, 'delete_comment']);
    Route::post('get_notification', [HomeController::class, 'get_notification']);
    Route::post('read_notification', [HomeController::class, 'read_notification']);
    Route::post('withdrawal_request', [HomeController::class, 'withdrawal_request']);
    Route::post('withdrawal_list', [HomeController::class, 'withdrawal_list']);
    Route::post('get_report_reason', [HomeController::class, 'get_report_reason']);
    Route::post('add_report', [HomeController::class, 'add_report']);
    Route::post('get_post', [HomeController::class, 'get_post']);
    Route::post('get_video_post', [HomeController::class, 'get_video_post']);
    Route::post('get_user_post', [HomeController::class, 'get_user_post']);
    Route::post('image_upload', [HomeController::class, 'image_upload']);
    Route::post('upload_post', [HomeController::class, 'upload_post']);
    Route::post('delete_post', [HomeController::class, 'delete_post']);
    Route::post('add_view', [HomeController::class, 'add_view']);
});
