<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Coin_Package_Transaction extends Model
{
    use HasFactory;

    protected $table = 'tbl_coin_package_transaction';
    protected $guarded = array();

    protected $casts = [
        'id' => 'integer',
        'user_id' => 'integer',
        'coin_package_id' => 'string',
        'price' => 'string',
        'coin' => 'integer',
        'transaction_id' => 'string',
        'description' => 'string',
        'status' => 'integer',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function coin_package()
    {
        return $this->belongsTo(Coin_Package::class, 'coin_package_id');
    }
}
