@extends('admin.layout.page-app')
@section('page_title', __('Label.edit_coin_package'))
@section('tab_title', __('Label.edit_coin_package'))

@section('content')
	@include('admin.layout.sidebar')

	<div class="right-content">
		@include('admin.layout.header')

		<div class="body-content">
			<!-- mobile title -->
			<h1 class="page-title-sm">{{__('Label.edit_coin_package')}}</h1>

			<div class="border-bottom row mb-3">
				<div class="col-sm-10">
					<ol class="breadcrumb">
						<li class="breadcrumb-item">
							<a href="{{ route('admin.dashboard') }}">{{__('Label.Dashboard')}}</a>
						</li>
						<li class="breadcrumb-item">
							<a href="{{ route('coin_package.index') }}">{{__('Label.coin_package')}}</a>
						</li>
						<li class="breadcrumb-item active" aria-current="page">
							{{__('Label.edit_coin_package')}}
						</li>
					</ol>
				</div>
				<div class="col-sm-2 d-flex align-items-center justify-content-end">
					<a href="{{ route('coin_package.index') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Label.coin_package_list')}}</a>
				</div>
			</div>

			<div class="card custom-border-card">
				<form id="package_update" enctype="multipart/form-data">
					<input type="hidden" name="id" value="@if($data){{$data->id}}@endif">
					<div class="form-row">
						<div class="col-md-9">
							<div class="form-row">
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('Label.Name')}}<span class="text-danger">*</span></label>
										<input type="text" name="name" value="@if($data){{$data->name}}@endif" class="form-control" placeholder="{{__('Label.Please Enter Name')}}" autofocus>
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('Label.Price')}}<span class="text-danger">*</span></label>
										<input type="number" name="price" value="@if($data){{$data->price}}@endif" min="0" class="form-control" placeholder="{{__('Label.Please Enter Price')}}">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('Label.coin')}}<span class="text-danger">*</span></label>
										<input type="number" name="coin" value="@if($data){{$data->coin}}@endif" min="0" class="form-control" placeholder="{{__('Label.Please Enter Coin')}}">
									</div>
								</div>
							</div>
							<div class="form-row">
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('Label.android_product_package')}}</label>
										<input name="android_product_package" type="text" class="form-control" placeholder="{{__('Label.enter_android_product_package')}}" value="@if($data){{$data->android_product_package}}@endif">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('Label.ios_product_package')}}</label>
										<input name="ios_product_package" type="text" class="form-control" placeholder="{{__('Label.enter_ios_product_package')}}" value="@if($data){{$data->ios_product_package}}@endif">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('Label.web_product_package')}}</label>
										<input name="web_product_package" type="text" class="form-control" placeholder="{{__('Label.enter_web_product_package')}}" value="@if($data){{$data->web_product_package}}@endif">
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-3">
                            <div class="form-group ml-5">
                                <label>{{__('Label.portrait_image')}}<span class="text-danger">*</span></label>
                                <div class="avatar-upload">
                                    <div class="avatar-edit">
                                        <input type='file' name="image" id="imageUpload" accept=".png, .jpg, .jpeg" />
                                        <label for="imageUpload" title="Select File"></label>
                                    </div>
                                    <div class="avatar-preview">
                                        <img src="{{$data->image}}" alt="upload_img.png" id="imagePreview">
                                    </div>
                                </div>
								<input type="hidden" name="old_image" value="@if($data){{$data->image}}@endif">
                                <label class="mt-3 text-gray">{{__('Label.maximum_size')}}</label>
                            </div>
                        </div>
					</div>
					<div class="border-top pt-3 text-right">
						<button type="button" class="btn btn-default mw-120" onclick="update_package()">{{__('Label.UPDATE')}}</button>
						<a href="{{route('coin_package.index')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
						<input type="hidden" name="_method" value="PATCH">
					</div>
				</form>
			</div>
		</div>
	</div>
@endsection

@section('pagescript')
	<script>
		// Sidebar Scroll Down
		sidebar_down($(document).height());

		function update_package() {
			var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

				$("#dvloader").show();
				var formData = new FormData($("#package_update")[0]);
				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					enctype: 'multipart/form-data',
					type: 'POST',
					url: '{{route("coin_package.update", [$data->id])}}',
					data: formData,
					cache: false,
					contentType: false,
					processData: false,
					success: function(resp) {
						$("#dvloader").hide();
						get_responce_message(resp, 'package_update', '{{ route("coin_package.index") }}');
					},
					error: function(XMLHttpRequest, textStatus, errorThrown) {
						$("#dvloader").hide();
						toastr.error(errorThrown, textStatus);
					}
				});
			} else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
		}
	</script>
@endsection