@extends('admin.layout.page-app')
@section('page_title',  __('Label.add_creator'))
@section('tab_title', __('Label.add_creator'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('Label.add_creator')}}</h1>
            <div class="border-bottom row mb-3">
                <div class="col-sm-10">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">{{__('Label.Dashboard')}}</a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('creator.index') }}">{{__('Label.Creator')}}</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Label.add_creator')}}</li>
                    </ol>
                </div>
                <div class="col-sm-2 d-flex align-items-center justify-content-end">
                    <a href="{{ route('creator.index') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Label.creator_list')}}</a>
                </div>
            </div>

            <div class="card custom-border-card mt-3">
                <form id="creator" enctype="multipart/form-data" autocomplete="off">
                    <input type="hidden" name="id" value="">
                    <div class="form-row">
                        <div class="col-md-8">
                            <div class="form-row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{__('Label.Full_Name')}}<span class="text-danger">*</span></label>
                                        <input type="text" name="full_name" class="form-control" placeholder="{{__('Label.full_name_here')}}" autofocus>
                                    </div>
                                </div> 
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{__('Label.Email')}}<span class="text-danger">*</span></label>
                                        <input type="email" name="email" class="form-control" placeholder="{{__('Label.email_here')}}">
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{__('Label.Password')}}<span class="text-danger">*</span></label>
                                        <input type="password" name="password" class="form-control" placeholder="{{__('Label.password_here')}}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{__('Label.Gender')}}<span class="text-danger">*</span></label>
                                        <select name="gender" class="form-control">
                                            <option value="Male">{{__('Label.male')}}</option>
                                            <option value="Female">{{__('Label.female')}}</option>
                                            <option value="Other">{{__('Label.other')}}</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{__('Label.Date_Of_Birth')}}<span class="text-danger">*</span></label>
                                        <input type="date" name="date_of_birth" max="<?php echo date('Y-m-d'); ?>" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{__('Label.Mobile Number')}}<span class="text-danger">*</span></label>
                                        <input type="text" name="mobile_number" class="form-control" placeholder="{{__('Label.mobile_number_here')}}">
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>{{__('Label.country_code')}}<span class="text-danger">*</span></label>
                                        <input type="text" name="country_code" class="form-control" placeholder="{{__('Label.+91')}}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>{{__('Label.country_name')}}<span class="text-danger">*</span></label>
                                        <input type="text" name="country_name" class="form-control" placeholder="{{__('Label.ind')}}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group ml-3">
                                        <label for="is_verified_at">{{__('Label.is_verified')}}<span class="text-danger">*</span></label>
                                        <div class="radio-group">
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="is_verified_at" name="is_verified_at" class="custom-control-input" value="1">
                                                <label class="custom-control-label" for="is_verified_at">{{__('Label.Yes')}}</label>
                                            </div>
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="is_verified_at1" name="is_verified_at" class="custom-control-input" value="0" checked>
                                                <label class="custom-control-label" for="is_verified_at1">{{__('Label.No')}}</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>{{__('Label.Bio')}}<span class="text-danger">*</span></label>
                                        <textarea name="bio" class="form-control" rows="1" placeholder="{{__('Label.describe_here')}}"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group ml-3">
                                <label>{{__('Label.portrait_image')}}<span class="text-danger">*</span></label>
                                <div class="avatar-upload">
                                    <div class="avatar-edit">
                                        <input type='file' name="image" id="imageUpload" accept=".png, .jpg, .jpeg" />
                                        <label for="imageUpload" title="Select File"></label>
                                    </div>
                                    <div class="avatar-preview">
                                        <img src="{{asset('assets/imgs/upload_img.png')}}" alt="upload_img.png" id="imagePreview">
                                    </div>
                                </div>
                                <label class="mt-3 text-gray">{{__('Label.maximum_size')}}</label>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>{{__('Label.cover_image')}}<span class="text-danger">*</span></label>
                                <div class="avatar-upload-landscape">
                                    <div class="avatar-edit-landscape">
                                        <input type='file' name="cover_img" id="imageUploadLandscape" accept=".png, .jpg, .jpeg" />
                                        <label for="imageUploadLandscape" title="Select File"></label>
                                    </div>
                                    <div class="avatar-preview-landscape">
                                        <img src="{{asset('assets/imgs/upload_img.png')}}" alt="upload_img.png" id="imagePreviewLandscape">
                                    </div>
                                </div>
                                <label class="mt-3 text-gray">{{__('Label.maximum_size')}}</label>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>{{__('Label.facebook_url')}}</label>
                                <input type="text" name="facebook_url" class="form-control" placeholder="{{__('Label.enter_url')}}">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>{{__('Label.instagram_url')}}</label>
                                <input type="text" name="instagram_url" class="form-control" placeholder="{{__('Label.enter_url')}}">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>{{__('Label.youtube_url')}}</label>
                                <input type="text" name="youtube_url" class="form-control" placeholder="{{__('Label.enter_url')}}">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>{{__('Label.twitter_url')}}</label>
                                <input type="text" name="twitter_url" class="form-control" placeholder="{{__('Label.enter_url')}}">
                            </div>
                        </div>
                    </div>
                    <div class="border-top pt-3 text-right">
                        <button type="button" class="btn btn-default mw-120" onclick="save_creator()">{{__('Label.SAVE')}}</button>
                        <a href="{{route('creator.index')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
	<script>
		function save_creator(){
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                $("#dvloader").show();
                var formData = new FormData($("#creator")[0]);
                $.ajax({
                    type:'POST',
                    url:'{{ route("creator.store") }}',
                    data:formData,
                    cache:false,
                    contentType: false,
                    processData: false,
                    success:function(resp){
                        $("#dvloader").hide();
                        get_responce_message(resp, 'creator', '{{ route("creator.index") }}');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);    
                    }
                });
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
		}
	</script>
@endsection